/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.IPersistentConfigInfo;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.util.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigInfo
implements IPersistentConfigInfo {
    private boolean canEject = true;
    private boolean ejecting = false;
    private final Map<RelativeSide, DataType> sideConfig = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
    private final Map<DataType, ISlotInfo> slotInfo;
    private final Map<Object, List<DataType>> containerTypeMapping;
    @Nullable
    private Set<RelativeSide> disabledSides;
    @Nullable
    private Set<DataType> supportedDataTypes;

    public ConfigInfo() {
        for (RelativeSide side : EnumUtils.SIDES) {
            this.sideConfig.put(side, DataType.NONE);
        }
        this.slotInfo = new EnumMap<DataType, ISlotInfo>(DataType.class);
        this.containerTypeMapping = new HashMap<Object, List<DataType>>();
    }

    public boolean canEject() {
        return this.canEject;
    }

    public void setCanEject(boolean canEject) {
        this.canEject = canEject;
    }

    @Override
    public boolean isEjecting() {
        return this.ejecting;
    }

    public void setEjecting(boolean ejecting) {
        this.ejecting = ejecting;
    }

    public void addDisabledSides(RelativeSide ... sides) {
        if (this.disabledSides == null) {
            this.disabledSides = EnumSet.noneOf(RelativeSide.class);
        }
        for (RelativeSide side : sides) {
            this.disabledSides.add(side);
            this.sideConfig.put(side, DataType.NONE);
        }
    }

    public boolean isSideEnabled(@NotNull RelativeSide side) {
        if (this.disabledSides == null) {
            return true;
        }
        return !this.disabledSides.contains(side);
    }

    @Override
    @NotNull
    public DataType getDataType(@NotNull RelativeSide side) {
        return this.sideConfig.get(side);
    }

    public Set<Map.Entry<RelativeSide, DataType>> getSideConfig() {
        return this.sideConfig.entrySet();
    }

    public boolean setDataType(@NotNull DataType dataType, @NotNull RelativeSide side) {
        return this.isSideEnabled(side) && this.sideConfig.put(side, dataType) != dataType;
    }

    @NotNull
    public Set<DataType> getSupportedDataTypes() {
        if (this.supportedDataTypes == null) {
            this.supportedDataTypes = EnumSet.of(DataType.NONE);
            this.supportedDataTypes.addAll(this.slotInfo.keySet());
        }
        return this.supportedDataTypes;
    }

    public boolean supports(DataType type) {
        return type == DataType.NONE || this.slotInfo.containsKey(type);
    }

    @Nullable
    public ISlotInfo getSlotInfo(@NotNull RelativeSide side) {
        return this.getSlotInfo(this.getDataType(side));
    }

    @Nullable
    public ISlotInfo getSlotInfo(@NotNull DataType dataType) {
        return this.slotInfo.get(dataType);
    }

    public void addSlotInfo(@NotNull DataType dataType, @NotNull ISlotInfo info) {
        this.slotInfo.put(dataType, info);
        if (this.supportedDataTypes != null) {
            this.supportedDataTypes.add(dataType);
        }
        ISlotInfo iSlotInfo = info;
        Objects.requireNonNull(iSlotInfo);
        ISlotInfo iSlotInfo2 = iSlotInfo;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalSlotInfo.class, FluidSlotInfo.class, InventorySlotInfo.class}, (Object)iSlotInfo2, n)) {
            case 0: {
                ChemicalSlotInfo chemicalSlotInfo = (ChemicalSlotInfo)iSlotInfo2;
                for (IChemicalTank tank : chemicalSlotInfo.getTanks()) {
                    this.containerTypeMapping.computeIfAbsent(tank, t -> new ArrayList()).add(dataType);
                }
                break;
            }
            case 1: {
                FluidSlotInfo fluidSlotInfo = (FluidSlotInfo)iSlotInfo2;
                for (IExtendedFluidTank tank : fluidSlotInfo.getTanks()) {
                    this.containerTypeMapping.computeIfAbsent(tank, t -> new ArrayList()).add(dataType);
                }
                break;
            }
            case 2: {
                InventorySlotInfo inventorySlotInfo = (InventorySlotInfo)iSlotInfo2;
                for (IInventorySlot slot : inventorySlotInfo.getSlots()) {
                    this.containerTypeMapping.computeIfAbsent(slot, t -> new ArrayList()).add(dataType);
                }
                break;
            }
        }
    }

    public List<DataType> getDataTypeForContainer(Object container) {
        return this.containerTypeMapping.getOrDefault(container, new ArrayList());
    }

    @NotNull
    public DataType incrementDataType(@NotNull RelativeSide relativeSide) {
        DataType current = this.getDataType(relativeSide);
        if (this.isSideEnabled(relativeSide)) {
            DataType newType = current.getNext(this::supports);
            this.sideConfig.put(relativeSide, newType);
            return newType;
        }
        return current;
    }

    @NotNull
    public DataType decrementDataType(@NotNull RelativeSide relativeSide) {
        DataType current = this.getDataType(relativeSide);
        if (this.isSideEnabled(relativeSide)) {
            DataType newType = current.getPrevious(this::supports);
            this.sideConfig.put(relativeSide, newType);
            return newType;
        }
        return current;
    }
}

