/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.item;

import com.folumo.mekanism_lasers.common.block_entity.ToggleableLaserBlockEntity;
import com.folumo.mekanism_lasers.common.registry.ComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class RemoteControlItem
extends Item {
    public RemoteControlItem(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).stacksTo(1).component((Supplier)MekanismDataComponents.CONFIGURATOR_MODE, (Object)ItemConfigurator.ConfiguratorMode.CONFIGURATE_ITEMS).component(ComponentRegistry.RC_BLOCKPOS, new ArrayList()).component(ComponentRegistry.RC_ACTIVITY, (Object)false));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return TextComponentUtil.build((Object[])new Object[]{EnumColor.AQUA, super.getName(stack)});
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            player.sendSystemMessage((Component)Component.literal((String)"Switching laser mode"));
            this.switchLaserMode(stack, world, player);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        BlockEntity tile;
        Player player = context.getPlayer();
        Level world = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (!world.isClientSide && player != null && (tile = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)(pos = context.getClickedPos()))) instanceof ToggleableLaserBlockEntity && ((ToggleableLaserBlockEntity)tile).ownerMatches(player)) {
            List<BlockPos> linkedLasers = this.getBlockPos(stack);
            if (linkedLasers.contains(pos)) {
                linkedLasers.remove(pos);
                player.sendSystemMessage((Component)Component.literal((String)"removed"));
            } else {
                linkedLasers.add(pos);
                player.sendSystemMessage((Component)Component.literal((String)"added"));
            }
            this.saveLinkedLasers(stack, linkedLasers);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void switchLaserMode(ItemStack stack, Level world, Player player) {
        stack.set(ComponentRegistry.RC_ACTIVITY, (Object)(!this.getActive(stack) ? 1 : 0));
        List<BlockPos> linkedLasers = this.getBlockPos(stack);
        boolean finalLasersStatus = this.getActive(stack);
        linkedLasers.forEach(pos2 -> {
            BlockEntity tile2 = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)pos2);
            if (tile2 instanceof ToggleableLaserBlockEntity) {
                ((ToggleableLaserBlockEntity)tile2).setLaserActivity(finalLasersStatus, player);
            }
        });
    }

    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return false;
    }

    private void saveLinkedLasers(ItemStack stack, List<BlockPos> linkedLasers) {
        stack.set(ComponentRegistry.RC_BLOCKPOS, linkedLasers);
    }

    private List<BlockPos> getBlockPos(ItemStack stack) {
        return new ArrayList<BlockPos>(Objects.requireNonNull((List)stack.getComponents().get(ComponentRegistry.RC_BLOCKPOS)));
    }

    private boolean getActive(ItemStack stack) {
        return Boolean.TRUE.equals(stack.getComponents().get(ComponentRegistry.RC_ACTIVITY));
    }
}

