/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.multiblock.validator;

import com.folumo.mekanism_lasers.common.block_entity.EnergyStorageCellBlockEntity;
import com.folumo.mekanism_lasers.common.multiblock.data.energyStorageMultiblockData;
import com.folumo.mekanism_lasers.common.registry.BlockTypeRegistry;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.lib.multiblock.StructureHelper;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class energyStorageMultiblockValidator
extends CuboidStructureValidator<energyStorageMultiblockData> {
    private final List<EnergyStorageCellBlockEntity> cells = new ArrayList<EnergyStorageCellBlockEntity>();
    private static final VoxelCuboid MIN_CUBOID = new VoxelCuboid(3, 4, 3);
    private static final VoxelCuboid MAX_CUBOID = new VoxelCuboid(3, 4, 3);

    public boolean precheck() {
        this.cuboid = StructureHelper.fetchCuboid((Structure)this.structure, (VoxelCuboid)MIN_CUBOID, (VoxelCuboid)MAX_CUBOID, EnumSet.complementOf(EnumSet.of(VoxelCuboid.CuboidSide.TOP)), (int)8);
        return this.cuboid != null;
    }

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.getBlock();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{BlockTypeRegistry.ENERGY_STORAGE_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{BlockTypeRegistry.ENERGY_STORAGE_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    protected boolean validateInner(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos) {
        BlockEntity tile;
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        if (BlockType.is((Block)state.getBlock(), (BlockType[])new BlockType[]{BlockTypeRegistry.ENERGY_STORAGE_CELL}) && (tile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, (BlockPos)pos)) instanceof EnergyStorageCellBlockEntity) {
            EnergyStorageCellBlockEntity cell = (EnergyStorageCellBlockEntity)tile;
            this.cells.add(cell);
            return true;
        }
        return false;
    }

    public FormationProtocol.FormationResult postcheck(energyStorageMultiblockData structure, Long2ObjectMap<ChunkAccess> chunkMap) {
        for (EnergyStorageCellBlockEntity cell : this.cells) {
            structure.addCell(cell);
        }
        return FormationProtocol.FormationResult.SUCCESS;
    }
}

