/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.registry;

import com.folumo.mekanism_lasers.common.block.BlockShapes;
import com.folumo.mekanism_lasers.common.block_entity.EnergyStorageCasingBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.EnergyStorageCellBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.EnergyStoragePortBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.EnergyTransformerBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.InterfaceBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.LaserBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.LaserSplitterBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.LaserStopperBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.OreGeneratorBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.ToggleableLaserBlockEntity;
import com.folumo.mekanism_lasers.common.lang.MekanismLasersLang;
import com.folumo.mekanism_lasers.common.registry.BlockEntityTypeRegistry;
import com.folumo.mekanism_lasers.common.registry.ContainerTypeRegistry;
import com.folumo.mekanism_lasers.common.tier.LaserTier;
import java.util.function.Supplier;
import mekanism.api.text.ILangEntry;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;

public class BlockTypeRegistry {
    public static final BlockTypeTile<LaserStopperBlockEntity> LASER_STOPPER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.LASER_STOPPER, (ILangEntry)MekanismLasersLang.DESCRIPTION_LASER_STOPPER).withCustomShape(BlockShapes.LASER_STOPPER_SHAPE)).without(new Class[]{AttributeParticleFX.class, AttributeStateFacing.class, Attributes.AttributeRedstone.class})).build();
    public static final BlockTypeTile<LaserSplitterBlockEntity> LASER_SPLITTER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.LASER_SPLITTER, (ILangEntry)MekanismLasersLang.DESCRIPTION_LASER_SPLITTER).withEnergyConfig(() -> LaserSplitterBlockEntity.getMaxEnergy() / 2L, LaserSplitterBlockEntity::getMaxEnergy).without(new Class[]{AttributeParticleFX.class, Attributes.AttributeRedstone.class})).with(new Attribute[]{Attributes.ACTIVE, new AttributeStateFacing(BlockStateProperties.FACING, AttributeStateFacing.FacePlacementType.SELECTED_FACE)})).build();
    public static final BlockTypeTile<EnergyTransformerBlockEntity> ENERGY_TRANSFORMER = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.ENERGY_TRANSFORMER, (ILangEntry)MekanismLasersLang.ENERGY_TRANSFORMER).withEnergyConfig(() -> 8000000000L, () -> 8000000000L).without(new Class[]{AttributeParticleFX.class, Attributes.AttributeRedstone.class})).with(new Attribute[]{Attributes.ACTIVE, new AttributeStateFacing(BlockStateProperties.FACING, AttributeStateFacing.FacePlacementType.SELECTED_FACE)})).build();
    public static final BlockTypeTile<LaserBlockEntity> BASIC_LASER = BlockTypeRegistry.createLaser(LaserTier.BASIC, () -> BlockEntityTypeRegistry.BASIC_LASER);
    public static final BlockTypeTile<LaserBlockEntity> ADVANCED_LASER = BlockTypeRegistry.createLaser(LaserTier.ADVANCED, () -> BlockEntityTypeRegistry.ADVANCED_LASER);
    public static final BlockTypeTile<LaserBlockEntity> ELITE_LASER = BlockTypeRegistry.createLaser(LaserTier.ELITE, () -> BlockEntityTypeRegistry.ELITE_LASER);
    public static final BlockTypeTile<LaserBlockEntity> ULTIMATE_LASER = BlockTypeRegistry.createLaser(LaserTier.ULTIMATE, () -> BlockEntityTypeRegistry.ULTIMATE_LASER);
    public static final BlockTypeTile<LaserBlockEntity> CREATIVE_LASER = BlockTypeRegistry.createLaser(LaserTier.CREATIVE, () -> BlockEntityTypeRegistry.CREATIVE_LASER);
    public static final BlockTypeTile<ToggleableLaserBlockEntity> BASIC_TOGGLEABLE_LASER = BlockTypeRegistry.createToggleableLaser(LaserTier.BASIC, () -> BlockEntityTypeRegistry.BASIC_TOGGLEABLE_LASER);
    public static final BlockTypeTile<ToggleableLaserBlockEntity> ADVANCED_TOGGLEABLE_LASER = BlockTypeRegistry.createToggleableLaser(LaserTier.ADVANCED, () -> BlockEntityTypeRegistry.ADVANCED_TOGGLEABLE_LASER);
    public static final BlockTypeTile<ToggleableLaserBlockEntity> ELITE_TOGGLEABLE_LASER = BlockTypeRegistry.createToggleableLaser(LaserTier.ELITE, () -> BlockEntityTypeRegistry.ELITE_TOGGLEABLE_LASER);
    public static final BlockTypeTile<ToggleableLaserBlockEntity> ULTIMATE_TOGGLEABLE_LASER = BlockTypeRegistry.createToggleableLaser(LaserTier.ULTIMATE, () -> BlockEntityTypeRegistry.ULTIMATE_TOGGLEABLE_LASER);
    public static final BlockTypeTile<ToggleableLaserBlockEntity> CREATIVE_TOGGLEABLE_LASER = BlockTypeRegistry.createToggleableLaser(LaserTier.CREATIVE, () -> BlockEntityTypeRegistry.CREATIVE_TOGGLEABLE_LASER);
    public static final BlockTypeTile<OreGeneratorBlockEntity> ORE_GENERATOR = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.ORE_GENERATOR, (ILangEntry)MekanismLasersLang.DESCRIPTION_ORE_GENERATOR).withEnergyConfig(OreGeneratorBlockEntity::getUsage, OreGeneratorBlockEntity::getEnergyCap).withSound(MekanismSounds.LASER).withGui(() -> ContainerTypeRegistry.ORE_GENERATOR).with(new Attribute[]{Attributes.ACTIVE, new AttributeStateFacing(BlockStateProperties.FACING, AttributeStateFacing.FacePlacementType.SELECTED_FACE), Attributes.SECURITY})).withCustomShape(BlockShapes.ORE_GENERATOR_SHAPE)).build();
    public static final BlockTypeTile<InterfaceBlockEntity> INTERFACE_BLOCK = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.INTERFACE_BLOCK, (ILangEntry)MekanismLasersLang.DESCRIPTION_INTERFACE_BLOCK).withGui(() -> ContainerTypeRegistry.INTERFACE_BLOCK).with(new Attribute[]{Attributes.ACTIVE, new AttributeStateFacing(BlockStateProperties.FACING, AttributeStateFacing.FacePlacementType.SELECTED_FACE), Attributes.SECURITY})).build();
    public static final BlockTypeTile<EnergyStorageCasingBlockEntity> ENERGY_STORAGE_CASING = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.ENERGY_STORAGE_CASING, (ILangEntry)MekanismLasersLang.DESCRIPTION_ENERGY_STORAGE_CASING).with(new Attribute[]{Attributes.INVENTORY, Attributes.COMPARATOR})).externalMultiblock()).build();
    public static final BlockTypeTile<EnergyStoragePortBlockEntity> ENERGY_STORAGE_PORT = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.ENERGY_STORAGE_PORT, (ILangEntry)MekanismLasersLang.DESCRIPTION_ENERGY_STORAGE_PORT).with(new Attribute[]{Attributes.INVENTORY, Attributes.COMPARATOR, Attributes.ACTIVE})).externalMultiblock()).build();
    public static final BlockTypeTile<EnergyStorageCellBlockEntity> ENERGY_STORAGE_CELL = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> BlockEntityTypeRegistry.ENERGY_STORAGE_CELL, (ILangEntry)MekanismLasersLang.DESCRIPTION_ENERGY_STORAGE_CELL).withCustomShape(BlockShapes.ENERGY_STORAGE_CELL_SHAPE)).withEnergyConfig(EnergyStorageCellBlockEntity::getMaxEnergy).internalMultiblock()).build();

    private static <TILE extends LaserBlockEntity> BlockTypeTile<TILE> createLaser(LaserTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile) {
        return (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(tile, (ILangEntry)MekanismLasersLang.DESCRIPTION_LASER).with(new Attribute[]{new AttributeTier((ITier)tier), new AttributeStateFacing(BlockStateProperties.FACING, AttributeStateFacing.FacePlacementType.SELECTED_FACE), Attributes.SECURITY})).withEnergyConfig(tier::getEnergyUsage, tier::getEnergyCap).withCustomShape(mekanism.common.content.blocktype.BlockShapes.LASER)).withSound(MekanismSounds.LASER).build();
    }

    private static <TILE extends ToggleableLaserBlockEntity> BlockTypeTile<TILE> createToggleableLaser(LaserTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile) {
        return (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(tile, (ILangEntry)MekanismLasersLang.DESCRIPTION_LASER_TOGGLEABLE).with(new Attribute[]{new AttributeTier((ITier)tier), new AttributeStateFacing(BlockStateProperties.FACING, AttributeStateFacing.FacePlacementType.SELECTED_FACE), Attributes.SECURITY})).withEnergyConfig(tier::getEnergyUsage, tier::getEnergyCap).withCustomShape(mekanism.common.content.blocktype.BlockShapes.LASER)).withSound(MekanismSounds.LASER).build();
    }
}

