/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.cache;

import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CacheFile {
    private static final String END_SEQUENCE = "###END###";
    public static final int MAX_RADIX = Math.min(36, 36);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean load(File file, String desiredId) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String id = reader.readLine();
            if (!id.equals(desiredId)) {
                NBTac.LOGGER.warn("Hash matches, but not id - corrupted file, error or hash collision");
                boolean bl = false;
                return bl;
            }
            boolean bl = CacheFile.parseFile(reader);
            return bl;
        }
        catch (Exception exception) {
            NBTac.LOGGER.error("Failed to load cache file!");
            Loader.printStackTrace(exception);
            return false;
        }
    }

    private static boolean parseFile(BufferedReader reader) throws Exception {
        String line = reader.readLine();
        if (line == null) {
            return false;
        }
        int lineCount = Integer.parseInt(line);
        if (lineCount < 0) {
            return false;
        }
        ParsedLine[] lines = new ParsedLine[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            line = reader.readLine();
            if (line == null) {
                return false;
            }
            lines[i] = new ParsedLine(line);
        }
        line = reader.readLine();
        if (line == null) {
            return false;
        }
        SuggestionStack stack = new SuggestionStack();
        int len = line.length();
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            if (line.charAt(i) != ';') continue;
            int id = Integer.parseInt(line, pos, i, MAX_RADIX);
            pos = i + 1;
            ParsedLine parsedLine = lines[id];
            if (parsedLine.depth == 0) {
                NbtSuggestions suggestions = new NbtSuggestions(true);
                NbtSuggestionManager.add(parsedLine.tag, suggestions);
                stack.addRoot(suggestions);
                continue;
            }
            if (stack.add(parsedLine.getSuggestion(), parsedLine.depth)) continue;
            return false;
        }
        line = reader.readLine();
        if (line == null) {
            return false;
        }
        return line.equals(END_SEQUENCE);
    }

    public static void save(File file, String id) {
        try (PrintWriter writer = new PrintWriter(file);){
            Builder builder = new Builder();
            for (Map.Entry<String, NbtSuggestions> suggestions : NbtSuggestionManager.suggestionSet()) {
                builder.add(suggestions.getKey());
                CacheFile.saveSuggestions(builder, suggestions.getValue(), 1);
            }
            writer.println(id);
            builder.finish(writer);
            writer.print(END_SEQUENCE);
        }
        catch (Exception exception) {
            NBTac.LOGGER.error("Failed to save cache file");
            Loader.printStackTrace(exception);
        }
    }

    private static void saveSuggestions(Builder builder, NbtSuggestions suggestions, int depth) {
        for (NbtSuggestion suggestion : suggestions.getAll()) {
            builder.add(CacheFile.packToLine(suggestion, depth));
            if (suggestion.subcompound == null) continue;
            CacheFile.saveSuggestions(builder, suggestion.subcompound, depth + 1);
        }
    }

    private static String packToLine(NbtSuggestion suggestion, int depth) {
        String tag = suggestion.tag;
        int type = suggestion.type.ordinal();
        int listType = suggestion.listType.ordinal();
        int source = suggestion.source.ordinal();
        return String.format("%s%d;%d;%d#%s", "-".repeat(depth), type, listType, source, tag);
    }

    private static class ParsedLine {
        private final String tag;
        private final NbtSuggestion.Type type;
        private final NbtSuggestion.Type listType;
        private final NbtSuggestion.Source source;
        public final int depth;

        public ParsedLine(String line) throws Exception {
            int calcDepth = 0;
            for (int i = 0; i < line.length() && line.charAt(i) == '-'; ++i) {
                ++calcDepth;
            }
            this.depth = calcDepth;
            if (this.depth == 0) {
                this.tag = line;
                this.type = null;
                this.listType = null;
                this.source = null;
                return;
            }
            int separator = line.indexOf("#");
            String sizesStr = line.substring(this.depth, separator);
            String[] values = sizesStr.split(";");
            if (values.length != 3) {
                throw new Exception();
            }
            try {
                this.tag = line.substring(separator + 1);
                this.type = NbtSuggestion.Type.fromOrdinal(Integer.parseInt(values[0]));
                this.listType = NbtSuggestion.Type.fromOrdinal(Integer.parseInt(values[1]));
                this.source = NbtSuggestion.Source.fromOrdinal(Integer.parseInt(values[2]));
            }
            catch (Exception exception) {
                throw new Exception();
            }
        }

        public NbtSuggestion getSuggestion() {
            return new NbtSuggestion(this.tag, this.type, this.source, this.listType);
        }
    }

    private static class SuggestionStack {
        private final ArrayList<NbtSuggestions> stack = new ArrayList();
        private NbtSuggestion lastSuggestion = null;

        private SuggestionStack() {
        }

        public void addRoot(NbtSuggestions suggestions) {
            this.stack.clear();
            this.stack.add(suggestions);
        }

        public boolean add(NbtSuggestion suggestion, int depth) {
            int currentDepth = this.stack.size() - 1;
            if (depth > currentDepth + 1) {
                return false;
            }
            NbtSuggestions suggestions = this.stack.get(depth - 1);
            if (suggestions == null) {
                suggestions = new NbtSuggestions(true);
                this.stack.set(depth - 1, suggestions);
                this.lastSuggestion.subcompound = suggestions;
            }
            suggestions.add(suggestion);
            if (depth == currentDepth + 1) {
                this.stack.add(null);
            } else if (depth < currentDepth) {
                this.stack.subList(depth, currentDepth).clear();
            }
            this.lastSuggestion = suggestion;
            return true;
        }
    }

    private static class Builder {
        private final Map<String, Integer> lineMap = new HashMap<String, Integer>();
        private final StringBuilder stringBuilder = new StringBuilder();
        private int lineCount = 0;

        private Builder() {
        }

        public void add(String line) {
            int finalId;
            Integer id = this.lineMap.get(line);
            if (id == null) {
                this.lineMap.put(line, this.lineCount);
                finalId = this.lineCount++;
            } else {
                finalId = id;
            }
            this.stringBuilder.append(Integer.toString(finalId, MAX_RADIX));
            this.stringBuilder.append(';');
        }

        public void finish(PrintWriter writer) {
            writer.println(this.lineCount);
            String[] lines = new String[this.lineCount];
            this.lineMap.forEach((key, value) -> {
                lines[value.intValue()] = key;
            });
            for (int i = 0; i < this.lineCount; ++i) {
                writer.println(lines[i]);
            }
            writer.println(this.stringBuilder);
        }
    }
}

