/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.RawSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.StringSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.utils.Fields;
import java.lang.reflect.Field;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class CustomSuggestion {
    protected final String text;
    @Nullable
    private final String subtext;
    private final int priority;

    protected CustomSuggestion(String text, @Nullable String subtext, int priority) {
        this.text = text;
        this.subtext = CustomSuggestion.getMarkedSubtext(subtext, priority);
        this.priority = priority;
    }

    public static CustomSuggestion fromType(String text, @Nullable String subtext, NbtSuggestion.Type type, CustomTagParser.Type parserType, int priority) {
        return type == NbtSuggestion.Type.STRING ? new StringSuggestion(text, subtext, parserType, priority) : new RawSuggestion(text, subtext, priority);
    }

    public String getVisibleText() {
        return this.text;
    }

    @Nullable
    public Message getTooltip() {
        return null;
    }

    public boolean match(String str) {
        return this.text.equals(str);
    }

    public boolean matchUnfinished(String str) {
        return CustomSuggestion.matchPrefix(this.text, str);
    }

    protected static boolean matchPrefix(String str, String prefix) {
        if (((Boolean)ModConfig.ignoreLetterCase.val).booleanValue()) {
            return str.toLowerCase().startsWith(prefix.toLowerCase());
        }
        return str.startsWith(prefix);
    }

    public void suggest(SuggestionsBuilder suggestionsBuilder) {
        boolean isEmptySuggestion;
        String visibleText = this.getVisibleText();
        Message tooltip = this.getTooltip();
        if (visibleText.isEmpty() && suggestionsBuilder.getRemaining().isEmpty()) {
            if (!CustomSuggestion.addEmptySuggestion(suggestionsBuilder, tooltip)) {
                NBTac.LOGGER.error("Something went wrong while adding empty suggestion!");
                return;
            }
            isEmptySuggestion = true;
        } else {
            suggestionsBuilder.suggest(visibleText, tooltip);
            isEmptySuggestion = false;
        }
        if (!((Boolean)ModConfig.showTagHints.val).booleanValue()) {
            return;
        }
        NbtSuggestionManager.clearIfNeeded(suggestionsBuilder);
        Suggestion lastAdded = CustomSuggestion.getLastAddedSuggestion(suggestionsBuilder);
        if (lastAdded != null) {
            NbtSuggestionManager.dataMap.put(lastAdded, new Data(this.subtext, this.priority, isEmptySuggestion));
        }
        NbtSuggestionManager.hasCustomSuggestions = true;
    }

    private static boolean addEmptySuggestion(SuggestionsBuilder suggestionsBuilder, @Nullable Message tooltip) {
        if (!((Boolean)ModConfig.showTagHints.val).booleanValue()) {
            return true;
        }
        if (Fields.suggestionsBuilderList == null) {
            return false;
        }
        try {
            List suggestions = (List)Fields.suggestionsBuilderList.get(suggestionsBuilder);
            int start = (Integer)Fields.suggestionsBuilderInt.get(suggestionsBuilder);
            int len = 0;
            for (Field stringField : Fields.suggestionsBuilderStrings) {
                String val = (String)stringField.get(suggestionsBuilder);
                if (val == null || val.length() <= len) continue;
                len = val.length();
            }
            suggestions.add(new Suggestion(StringRange.between((int)start, (int)len), "", tooltip));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nullable
    private static Suggestion getLastAddedSuggestion(SuggestionsBuilder suggestionsBuilder) {
        if (Fields.suggestionsBuilderList == null) {
            return null;
        }
        try {
            List suggestionList = (List)Fields.suggestionsBuilderList.get(suggestionsBuilder);
            return (Suggestion)suggestionList.get(suggestionList.size() - 1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private static String getMarkedSubtext(@Nullable String subtext, int priority) {
        if (subtext != null && !subtext.isEmpty()) {
            if (priority >= 100 && ((Boolean)ModConfig.markRecommended.val).booleanValue()) {
                return "<*> " + subtext;
            }
            if (priority < 0 && ((Boolean)ModConfig.markIrrelevant.val).booleanValue()) {
                return "<I> " + subtext;
            }
        } else {
            if (priority >= 100 && ((Boolean)ModConfig.markRecommended.val).booleanValue()) {
                return "<*>";
            }
            if (priority < 0 && ((Boolean)ModConfig.markIrrelevant.val).booleanValue()) {
                return "<I>";
            }
        }
        return subtext;
    }

    public static class Data {
        private static final Data ERROR = new Data("error, pls report", 9999, false);
        public final String subtext;
        public final int priority;
        public int order = 0;

        public Data(@Nullable String subtext, int priority, boolean isEmptySuggestion) {
            this.subtext = subtext == null || isEmptySuggestion || subtext.isEmpty() || subtext.charAt(0) == ' ' ? subtext : "  " + subtext;
            this.priority = priority;
        }

        public static Data error() {
            Data.ERROR.order = Data.ERROR.priority;
            return ERROR;
        }
    }
}

