/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions.selectors;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockStateParser.class})
public class BlockStateParserMixin {
    @Shadow
    @Final
    private StringReader reader;
    @Shadow
    @Nullable
    private BlockState state;
    @Shadow
    @Nullable
    private CompoundTag nbt;
    @Shadow
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions;

    @Inject(method={"readNbt"}, at={@At(value="HEAD")}, cancellable=true)
    protected void atReadNbt(CallbackInfo ci) throws CommandSyntaxException {
        ci.cancel();
        int cursorPos = this.reader.getCursor();
        try {
            this.nbt = new TagParser(this.reader).readStruct();
        }
        catch (CommandSyntaxException exception) {
            this.reader.setCursor(cursorPos);
            this.suggestions = this::suggestNbt;
            throw exception;
        }
    }

    @Unique
    private CompletableFuture<Suggestions> suggestNbt(SuggestionsBuilder suggestionsBuilder) {
        if (this.state == null) {
            return Suggestions.empty();
        }
        ResourceLocation resourceLocation = RegistryUtils.BLOCK.getKey(this.state.getBlock());
        String name = resourceLocation.toString();
        String tag = suggestionsBuilder.getRemaining();
        return NbtSuggestionManager.loadFromName("block/" + name, tag, suggestionsBuilder, false);
    }
}

