/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNSSTag<TYPE>
implements NSSTag {
    private static final Set<NSSTag> createdTags = new HashSet<NSSTag>();
    @NotNull
    private final ResourceLocation resourceLocation;
    private final boolean isTag;

    public static Set<NSSTag> getAllCreatedTags() {
        return Set.copyOf(createdTags);
    }

    public static void clearCreatedTags() {
        createdTags.clear();
    }

    protected AbstractNSSTag(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        this.resourceLocation = resourceLocation;
        this.isTag = isTag;
        if (isTag) {
            createdTags.add(this);
        }
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @NotNull
    protected abstract Registry<TYPE> getRegistry();

    protected final Optional<HolderSet.Named<TYPE>> getTag(Registry<TYPE> registry) {
        if (this.representsTag()) {
            return registry.getTag(TagKey.create((ResourceKey)registry.key(), (ResourceLocation)this.getResourceLocation()));
        }
        return Optional.empty();
    }

    protected abstract NormalizedSimpleStack createNew(Holder<TYPE> var1);

    @Override
    public boolean representsTag() {
        return this.isTag;
    }

    @Override
    public void forEachElement(Consumer<NormalizedSimpleStack> consumer) {
        Optional<HolderSet.Named<TYPE>> tag = this.getTag(this.getRegistry());
        if (tag.isPresent()) {
            for (Holder holder : tag.get()) {
                consumer.accept(this.createNew(holder));
            }
        }
    }

    @Override
    public <CONTEXT, DATA> void forEachElement(CONTEXT context, DATA data, TriConsumer<CONTEXT, NormalizedSimpleStack, DATA> consumer) {
        Optional<HolderSet.Named<TYPE>> tag = this.getTag(this.getRegistry());
        if (tag.isPresent()) {
            for (Holder holder : tag.get()) {
                consumer.accept(context, (Object)this.createNew(holder), data);
            }
        }
    }

    @Override
    public String toString() {
        ResourceLocation type = this.getRegistry().key().location();
        if (this.representsTag()) {
            return String.valueOf(type) + " Tag: " + String.valueOf(this.getResourceLocation());
        }
        return String.valueOf(type) + ": " + String.valueOf(this.getResourceLocation());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AbstractNSSTag other = (AbstractNSSTag)o;
            return this.representsTag() == other.representsTag() && this.getResourceLocation().equals((Object)other.getResourceLocation());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isTag, this.resourceLocation);
    }

    protected static <TYPE, NSS extends AbstractNSSTag<TYPE>> MapCodec<NSS> createTagCodec(NSSTagConstructor<TYPE, NSS> nssConstructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)IPECodecHelper.INSTANCE.validatePresent(ResourceLocation.CODEC, () -> "Must represent a tag").fieldOf("tag").forGetter(nss -> nss.representsTag() ? nss.getResourceLocation() : null)).apply((Applicative)instance, nssConstructor::createTag));
    }

    protected static <TYPE, NSS extends AbstractNSSTag<TYPE>> RecordCodecBuilder<NSS, ResourceLocation> idComponent(Registry<?> registry, boolean allowDefault) {
        return ResourceLocation.CODEC.validate(id -> {
            DefaultedRegistry defaultedRegistry;
            if (id == null) {
                return DataResult.error(() -> "Must represent a registry id");
            }
            if (!registry.containsKey(id)) {
                return DataResult.error(() -> "Registry " + String.valueOf(registry.key().location()) + " does not contain element " + String.valueOf(id));
            }
            if (!allowDefault && registry instanceof DefaultedRegistry && id.equals((Object)(defaultedRegistry = (DefaultedRegistry)registry).getDefaultKey())) {
                return DataResult.error(() -> "NormalizedSimpleStack cannot be created for registry " + String.valueOf(registry.key().location()) + " with the default element " + String.valueOf(id));
            }
            return DataResult.success((Object)id);
        }).fieldOf("id").forGetter(nss -> nss.representsTag() ? null : nss.getResourceLocation());
    }

    protected static <TYPE, NSS extends AbstractNSSTag<TYPE>> MapCodec<NSS> createCodec(Registry<TYPE> registry, boolean allowDefault, NSSTagConstructor<TYPE, NSS> nssConstructor) {
        return NeoForgeExtraCodecs.withAlternative(AbstractNSSTag.createTagCodec(nssConstructor), (MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group(AbstractNSSTag.idComponent(registry, allowDefault)).apply((Applicative)instance, nssConstructor::create)));
    }

    @FunctionalInterface
    protected static interface NSSTagConstructor<TYPE, NSS extends AbstractNSSTag<TYPE>> {
        public NSS create(ResourceLocation var1, boolean var2);

        default public NSS create(ResourceLocation rl) {
            return this.create(rl, false);
        }

        default public NSS createTag(ResourceLocation rl) {
            return this.create(rl, true);
        }
    }
}

