/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.ToLongFunction;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.components.IDataComponentProcessor;
import moze_intel.projecte.config.MappingConfig;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.components.ComponentProcessorHelper;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.utils.AnnotationHelper;
import net.minecraft.core.component.DataComponentPatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class DataComponentManager {
    private static final List<IDataComponentProcessor> processors = new ArrayList<IDataComponentProcessor>();

    public static List<IDataComponentProcessor> loadProcessors() {
        if (processors.isEmpty()) {
            processors.addAll(AnnotationHelper.getDataComponentProcessors());
        }
        return Collections.unmodifiableList(processors);
    }

    public static void updateCachedValues(@Nullable ToLongFunction<ItemInfo> emcLookup) {
        ComponentProcessorHelper.instance().updateCachedValues(emcLookup);
        for (IDataComponentProcessor processor : processors) {
            if (!MappingConfig.isEnabled(processor)) continue;
            processor.updateCachedValues(emcLookup);
        }
    }

    @NotNull
    static ItemInfo getPersistentInfo(@NotNull ItemInfo info) {
        if (!info.hasModifiedComponents() || info.getItem().is(PETags.Items.DATA_COMPONENT_WHITELIST) || EMCMappingHandler.hasEmcValue(info)) {
            return info;
        }
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        for (IDataComponentProcessor processor : processors) {
            if (!MappingConfig.isEnabled(processor) || !processor.hasPersistentComponents() || !MappingConfig.hasPersistent(processor)) continue;
            processor.collectPersistentComponents(info, builder);
        }
        return ItemInfo.fromItem(info.getItem(), builder.build());
    }

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcValue(@NotNull ItemInfo info) {
        long emcValue = EMCMappingHandler.getStoredEmcValue(info);
        if (!info.hasModifiedComponents()) {
            return emcValue;
        }
        if (emcValue == 0L && (emcValue = EMCMappingHandler.getStoredEmcValue(info.itemOnly())) == 0L) {
            return 0L;
        }
        for (IDataComponentProcessor processor : processors) {
            if (!MappingConfig.isEnabled(processor)) continue;
            try {
                emcValue = processor.recalculateEMC(info, emcValue);
            }
            catch (ArithmeticException e) {
                return 0L;
            }
            if (emcValue > 0L) continue;
            return 0L;
        }
        return emcValue;
    }
}

