/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.event.PlayerAttemptCondenserSetEvent;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.EmcChestBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.container.CondenserContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CondenserBlockEntity
extends EmcChestBlockEntity {
    public static final ICapabilityProvider<CondenserBlockEntity, @Nullable Direction, IItemHandler> INVENTORY_PROVIDER = (condenser, side) -> condenser.automationInventory;
    protected final ItemStackHandler inputInventory = this.createInput();
    private final ItemStackHandler outputInventory = this.createOutput();
    @Nullable
    private ItemInfo lockInfo;
    private boolean isAcceptingEmc;
    public long displayEmc;
    public long requiredEmc;
    private int loadIndex = EMCMappingHandler.getLoadIndex() - 1;
    private final IItemHandler automationInventory = this.createAutomationInventory();

    public CondenserBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityTypeRegistryObject<? extends CondenserBlockEntity>)PEBlockEntityTypes.CONDENSER, pos, state);
    }

    protected CondenserBlockEntity(BlockEntityTypeRegistryObject<? extends CondenserBlockEntity> type, BlockPos pos, BlockState state) {
        super((BlockEntityTypeRegistryObject<? extends EmcChestBlockEntity>)type, pos, state);
    }

    @Override
    protected boolean canAcceptEmc() {
        return this.isAcceptingEmc;
    }

    @Override
    protected boolean canProvideEmc() {
        return false;
    }

    @Nullable
    public final ItemInfo getLockInfo() {
        if (!(this.requiredEmc != 0L || this.level != null && this.level.isClientSide)) {
            return null;
        }
        return this.lockInfo;
    }

    public ItemStackHandler getInput() {
        return this.inputInventory;
    }

    public ItemStackHandler getOutput() {
        return this.outputInventory;
    }

    protected ItemStackHandler createInput() {
        return new EmcBlockEntity.StackHandler(91);
    }

    protected ItemStackHandler createOutput() {
        return this.inputInventory;
    }

    @NotNull
    protected IItemHandler createAutomationInventory() {
        return new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN_OUT){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserBlockEntity.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            @NotNull
            public ItemStack extractItem(int slot, int max, boolean simulate) {
                return CondenserBlockEntity.this.isStackEqualToLock(this.getStackInSlot(slot)) ? super.extractItem(slot, max, simulate) : ItemStack.EMPTY;
            }
        };
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, CondenserBlockEntity condenser) {
        condenser.checkLockAndUpdate(false);
        condenser.displayEmc = condenser.getStoredEmc();
        if (condenser.getLockInfo() != null) {
            condenser.condense();
        }
        condenser.updateComparators(level, pos);
    }

    private void checkLockAndUpdate(boolean force) {
        long lockEmc;
        if (!force && this.loadIndex == EMCMappingHandler.getLoadIndex()) {
            return;
        }
        this.loadIndex = EMCMappingHandler.getLoadIndex();
        if (this.lockInfo != null && (lockEmc = IEMCProxy.INSTANCE.getValue(this.lockInfo)) > 0L) {
            if (this.requiredEmc != lockEmc) {
                this.requiredEmc = lockEmc;
                this.isAcceptingEmc = true;
            }
            return;
        }
        this.displayEmc = 0L;
        this.requiredEmc = 0L;
        this.isAcceptingEmc = false;
    }

    protected void condense() {
        int slots = this.inputInventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = this.inputInventory.getStackInSlot(i);
            if (stack.isEmpty() || this.isStackEqualToLock(stack)) continue;
            this.inputInventory.extractItem(i, 1, false);
            this.forceInsertEmc(IEMCProxy.INSTANCE.getSellValue(stack), IEmcStorage.EmcAction.EXECUTE);
            break;
        }
        if (this.getStoredEmc() >= this.requiredEmc && this.hasSpace()) {
            this.forceExtractEmc(this.requiredEmc, IEmcStorage.EmcAction.EXECUTE);
            this.pushStack();
        }
    }

    protected final void pushStack() {
        ItemInfo lockInfo = this.getLockInfo();
        if (lockInfo != null) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)lockInfo.createStack(), (boolean)false);
        }
    }

    protected boolean hasSpace() {
        int slots = this.outputInventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = this.outputInventory.getStackInSlot(i);
            if (!stack.isEmpty() && (!this.isStackEqualToLock(stack) || stack.getCount() >= stack.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    public boolean isStackEqualToLock(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ItemInfo lockInfo = this.getLockInfo();
        if (lockInfo == null) {
            return false;
        }
        return lockInfo.equals(IEMCProxy.INSTANCE.getPersistentInfo(ItemInfo.fromStack(stack)));
    }

    public void setLockInfoFromPacket(@Nullable ItemInfo lockInfo) {
        this.lockInfo = lockInfo;
    }

    public boolean attemptCondenserSet(Player player) {
        return this.level != null && this.attemptCondenserSet(this.level, this.worldPosition, player);
    }

    private boolean attemptCondenserSet(@NotNull Level level, @NotNull BlockPos pos, Player player) {
        if (level.isClientSide) {
            return false;
        }
        if (this.getLockInfo() == null) {
            ItemStack stack = player.containerMenu.getCarried();
            if (!stack.isEmpty()) {
                ItemInfo reducedInfo;
                ItemInfo sourceInfo = ItemInfo.fromStack(stack);
                if (!((PlayerAttemptCondenserSetEvent)NeoForge.EVENT_BUS.post((Event)new PlayerAttemptCondenserSetEvent(player, sourceInfo, reducedInfo = IEMCProxy.INSTANCE.getPersistentInfo(sourceInfo)))).isCanceled()) {
                    this.lockInfo = reducedInfo;
                    this.checkLockAndUpdate(true);
                    this.markDirty(level, pos, false);
                    return true;
                }
                return false;
            }
            if (this.lockInfo == null) {
                return false;
            }
        }
        this.lockInfo = null;
        this.checkLockAndUpdate(true);
        this.markDirty(level, pos, false);
        return true;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inputInventory.deserializeNBT(registries, tag.getCompound("input"));
        this.lockInfo = tag.contains("lock") ? (ItemInfo)ItemInfo.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("lock")).result().orElse(null) : null;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        DataResult result;
        super.saveAdditional(tag, registries);
        tag.put("input", (Tag)this.inputInventory.serializeNBT(registries));
        if (this.lockInfo != null && (result = ItemInfo.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.lockInfo)).isSuccess()) {
            tag.put("lock", (Tag)result.getOrThrow());
        }
    }

    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerIn) {
        return new CondenserContainer(windowId, playerInventory, this);
    }

    @NotNull
    public Component getDisplayName() {
        return TextComponentUtil.build(PEBlocks.CONDENSER);
    }
}

