/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import com.mojang.serialization.MapCodec;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.block_entities.DMFurnaceBlockEntity;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.blocks.PEEntityBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlockTypes;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatterFurnace
extends AbstractFurnaceBlock
implements IMatterBlock,
PEEntityBlock<DMFurnaceBlockEntity> {
    private final EnumMatterType matterType;

    public MatterFurnace(BlockBehaviour.Properties props, EnumMatterType type) {
        super(props);
        this.matterType = type;
    }

    @Override
    @Nullable
    public BlockEntityTypeRegistryObject<? extends DMFurnaceBlockEntity> getType() {
        return this.matterType == EnumMatterType.RED_MATTER ? PEBlockEntityTypes.RED_MATTER_FURNACE : PEBlockEntityTypes.DARK_MATTER_FURNACE;
    }

    @NotNull
    protected MapCodec<MatterFurnace> codec() {
        return (MapCodec)PEBlockTypes.MATTER_FURNACE.value();
    }

    protected void openContainer(Level level, @NotNull BlockPos pos, @NotNull Player player) {
        DMFurnaceBlockEntity furnace;
        if (!level.isClientSide && (furnace = WorldHelper.getBlockEntity(DMFurnaceBlockEntity.class, (BlockGetter)level, pos, true)) != null) {
            player.openMenu((MenuProvider)furnace, pos);
        }
    }

    @Deprecated
    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            IItemHandler handler = (IItemHandler)WorldHelper.getCapability(level, Capabilities.ItemHandler.BLOCK, pos, state, null, null);
            WorldHelper.dropInventory(handler, level, pos);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Deprecated
    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((IItemHandler)WorldHelper.getCapability(level, Capabilities.ItemHandler.BLOCK, pos, state, null, null)));
    }

    @Override
    public EnumMatterType getMatterType() {
        return this.matterType;
    }
}

