/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import com.mojang.serialization.MapCodec;
import moze_intel.projecte.gameObjs.container.TransmutationContainer;
import moze_intel.projecte.gameObjs.registries.PEBlockTypes;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmutationStone
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape UP_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);

    public TransmutationStone(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends DirectionalBlock> codec() {
        return (MapCodec)PEBlockTypes.TRANSMUTATION_TABLE.value();
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> props) {
        super.createBlockStateDefinition(props);
        props.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED});
    }

    @Deprecated
    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @Deprecated
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.UP -> UP_SHAPE;
        };
    }

    @Deprecated
    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult rtr) {
        if (!level.isClientSide) {
            player.openMenu((MenuProvider)new ContainerProvider(), b -> b.writeBoolean(false));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state == null ? null : (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    @Deprecated
    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Deprecated
    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Deprecated
    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    private static class ContainerProvider
    implements MenuProvider {
        private ContainerProvider() {
        }

        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player player) {
            return new TransmutationContainer(windowId, playerInventory);
        }

        @NotNull
        public Component getDisplayName() {
            return PELang.TRANSMUTATION_TRANSMUTE.translate();
        }
    }
}

