/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.recipe_viewer.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Collection;
import java.util.HashSet;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.recipe_viewer.FuelUpgradeRecipe;
import moze_intel.projecte.integration.recipe_viewer.RecipeViewerHelper;
import moze_intel.projecte.integration.recipe_viewer.WorldTransmuteEntry;
import moze_intel.projecte.integration.recipe_viewer.emi.CollectorEmiRecipe;
import moze_intel.projecte.integration.recipe_viewer.emi.WorldTransmuteEmiRecipe;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class PEEmiPlugin
implements EmiPlugin {
    private static final Comparison PROJECTE_COMPARISON = Comparison.compareData(emiStack -> {
        Long stored;
        HashSet<Object> representation = new HashSet<Object>();
        ItemStack stack = emiStack.getItemStack();
        Item patt0$temp = stack.getItem();
        if (patt0$temp instanceof IModeChanger) {
            IModeChanger modeChanger = (IModeChanger)patt0$temp;
            representation.add(modeChanger.getMode(stack));
        }
        if ((stored = (Long)stack.get(PEDataComponentTypes.STORED_EMC)) != null && stored > 0L) {
            representation.add(stored);
        }
        return representation.isEmpty() ? null : representation;
    });

    public void register(EmiRegistry registry) {
        registry.addCategory(WorldTransmuteEmiRecipe.CATEGORY);
        for (WorldTransmuteEntry worldTransmuteEntry : RecipeViewerHelper.getAllTransmutations()) {
            registry.addRecipe((EmiRecipe)new WorldTransmuteEmiRecipe(worldTransmuteEntry));
        }
        registry.addCategory(CollectorEmiRecipe.CATEGORY);
        for (FuelUpgradeRecipe fuelUpgradeRecipe : RecipeViewerHelper.getFuelUpgrades()) {
            registry.addRecipe((EmiRecipe)new CollectorEmiRecipe(fuelUpgradeRecipe));
        }
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of(PEItems.PHILOSOPHERS_STONE));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiIngredient.of(PETags.Items.MATTER_FURNACES));
        registry.addWorkstation(CollectorEmiRecipe.CATEGORY, EmiIngredient.of(PETags.Items.COLLECTORS));
        registry.addWorkstation(WorldTransmuteEmiRecipe.CATEGORY, (EmiIngredient)EmiStack.of(PEItems.PHILOSOPHERS_STONE));
        PEEmiPlugin.registerItemSubtypes(registry, PEItems.ITEMS.getEntries());
        PEEmiPlugin.registerItemSubtypes(registry, PEBlocks.BLOCKS.getSecondaryEntries());
    }

    public static void registerItemSubtypes(EmiRegistry registry, Collection<? extends Holder<? extends ItemLike>> itemProviders) {
        for (Holder<? extends ItemLike> holder : itemProviders) {
            Item item = ((ItemLike)holder.value()).asItem();
            if (!(item instanceof IModeChanger) && !item.components().has((DataComponentType)PEDataComponentTypes.STORED_EMC.get())) continue;
            registry.setDefaultComparison((Object)item, PROJECTE_COMPARISON);
        }
    }
}

