/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_client;

import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.SequencedSet;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.SimpleWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.WorldTransmutation;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.world_transmutation.WorldTransmutationManager;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncWorldTransmutations(Reference2ObjectMap<Block, SequencedSet<IWorldTransmutation>> transmutations) implements IPEPacket
{
    public static final CustomPacketPayload.Type<SyncWorldTransmutations> TYPE = new CustomPacketPayload.Type(PECore.rl("sync_world_transmutations"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncWorldTransmutations> STREAM_CODEC = ByteBufCodecs.map(Reference2ObjectLinkedOpenHashMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), (StreamCodec)ByteBufCodecs.collection(LinkedHashSet::new, (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, IWorldTransmutation>(){

        public void encode(@NotNull RegistryFriendlyByteBuf buffer, @NotNull IWorldTransmutation value) {
            IWorldTransmutation iWorldTransmutation = value;
            Objects.requireNonNull(iWorldTransmutation);
            IWorldTransmutation iWorldTransmutation2 = iWorldTransmutation;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleWorldTransmutation.class, WorldTransmutation.class}, (Object)iWorldTransmutation2, n)) {
                case 0: {
                    SimpleWorldTransmutation transmutation = (SimpleWorldTransmutation)iWorldTransmutation2;
                    buffer.writeBoolean(false);
                    SimpleWorldTransmutation.STREAM_CODEC.encode((Object)buffer, (Object)transmutation);
                    break;
                }
                case 1: {
                    WorldTransmutation transmutation = (WorldTransmutation)iWorldTransmutation2;
                    buffer.writeBoolean(true);
                    WorldTransmutation.STREAM_CODEC.encode((Object)buffer, (Object)transmutation);
                    break;
                }
                default: {
                    throw new EncoderException("Unknown world transmutation implementation: " + String.valueOf(value));
                }
            }
        }

        @NotNull
        public IWorldTransmutation decode(@NotNull RegistryFriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                return (IWorldTransmutation)WorldTransmutation.STREAM_CODEC.decode((Object)buffer);
            }
            return (IWorldTransmutation)SimpleWorldTransmutation.STREAM_CODEC.decode((Object)buffer);
        }
    })).map(SyncWorldTransmutations::new, SyncWorldTransmutations::transmutations);

    @NotNull
    public CustomPacketPayload.Type<SyncWorldTransmutations> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        PECore.debugLog("Receiving World Transmutation data from server.", new Object[0]);
        WorldTransmutationManager.INSTANCE.setEntries(this.transmutations);
    }
}

