/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_client.knowledge;

import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.container.TransmutationContainer;
import moze_intel.projecte.network.packets.IPEPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record KnowledgeSyncChangePKT(ItemInfo change, boolean learned) implements IPEPacket
{
    public static final CustomPacketPayload.Type<KnowledgeSyncChangePKT> TYPE = new CustomPacketPayload.Type(PECore.rl("knowledge_sync_change"));
    public static final StreamCodec<RegistryFriendlyByteBuf, KnowledgeSyncChangePKT> STREAM_CODEC = StreamCodec.composite(ItemInfo.STREAM_CODEC, KnowledgeSyncChangePKT::change, (StreamCodec)ByteBufCodecs.BOOL, KnowledgeSyncChangePKT::learned, KnowledgeSyncChangePKT::new);

    @NotNull
    public CustomPacketPayload.Type<KnowledgeSyncChangePKT> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        IKnowledgeProvider knowledge = (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
        if (knowledge != null) {
            AbstractContainerMenu abstractContainerMenu;
            if (this.learned) {
                AbstractContainerMenu abstractContainerMenu2;
                if (!knowledge.hasKnowledge(this.change) && knowledge.addKnowledge(this.change) && (abstractContainerMenu2 = player.containerMenu) instanceof TransmutationContainer) {
                    TransmutationContainer container = (TransmutationContainer)abstractContainerMenu2;
                    container.transmutationInventory.itemLearned(this.change);
                }
            } else if (knowledge.hasKnowledge(this.change) && knowledge.removeKnowledge(this.change) && (abstractContainerMenu = player.containerMenu) instanceof TransmutationContainer) {
                TransmutationContainer container = (TransmutationContainer)abstractContainerMenu;
                container.transmutationInventory.itemUnlearned(this.change);
            }
        }
        PECore.debugLog("** RECEIVED TRANSMUTATION KNOWLEDGE CHANGE DATA CLIENTSIDE **", new Object[0]);
    }
}

