/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public record MessageChangeSocketableSlot(int slot) implements CustomPacketPayload
{
    public static final ResourceLocation ID = Psi.location("message_change_socketable_slot");
    public static final CustomPacketPayload.Type<MessageChangeSocketableSlot> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageChangeSocketableSlot> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageChangeSocketableSlot::slot, MessageChangeSocketableSlot::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            ISocketable socketable = (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY);
            if (!stack.isEmpty() && socketable != null) {
                socketable.setSelectedSlot(this.slot);
            } else {
                stack = player.getItemInHand(InteractionHand.OFF_HAND);
                socketable = (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY);
                if (!stack.isEmpty() && socketable != null) {
                    socketable.setSelectedSlot(this.slot);
                }
            }
            PlayerDataHandler.get(player).stopLoopcast();
        });
    }
}

