/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellHelpers;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickTorrent
extends PieceTrick {
    SpellParam<Vector3> position;

    public PieceTrickTorrent(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(20.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(80.0));
    }

    public static boolean placeWater(@Nullable Player playerIn, Level worldIn, BlockPos pos) {
        if (playerIn == null || worldIn.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()), ChunkStatus.FULL, false) == null || !worldIn.mayInteract(playerIn, pos)) {
            return false;
        }
        BlockState blockstate = worldIn.getBlockState(pos);
        boolean flag = blockstate.canBeReplaced((Fluid)Fluids.WATER);
        if (blockstate.isAir() || flag || blockstate.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid(playerIn, (BlockGetter)worldIn, pos, blockstate, (Fluid)Fluids.WATER)) {
            if (worldIn.dimensionType().ultraWarm()) {
                int i = pos.getX();
                int j = pos.getY();
                int k = pos.getZ();
                worldIn.playSound(playerIn, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.getBlock() instanceof LiquidBlockContainer) {
                if (((LiquidBlockContainer)blockstate.getBlock()).placeLiquid((LevelAccessor)worldIn, pos, blockstate, Fluids.WATER.getSource(false))) {
                    worldIn.playSound(playerIn, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                if (!worldIn.isClientSide && flag && !PieceTrickTorrent.isLiquid(blockstate)) {
                    worldIn.destroyBlock(pos, true);
                }
                worldIn.playSound(playerIn, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.setBlock(pos, Fluids.WATER.defaultFluidState().createLegacyBlock(), 11);
            }
            return true;
        }
        return false;
    }

    private static boolean isLiquid(BlockState pState) {
        return pState == Blocks.WATER.defaultBlockState() || pState == Blocks.LAVA.defaultBlockState();
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 80);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (context.focalPoint.getCommandSenderWorld().dimensionType().ultraWarm()) {
            return null;
        }
        BlockPos pos = SpellHelpers.getBlockPos(this, context, this.position, true, false);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)context.focalPoint.getCommandSenderWorld().dimension(), (LevelAccessor)context.focalPoint.getCommandSenderWorld(), (BlockPos)pos), context.focalPoint.getCommandSenderWorld().getBlockState(pos.relative(Direction.UP)), (Entity)context.caster);
        NeoForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            return null;
        }
        return PieceTrickTorrent.placeWater(context.caster, context.focalPoint.level(), pos);
    }
}

