/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellHelpers;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickMoveBlockSequence
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;
    SpellParam<Vector3> direction;
    SpellParam<Number> maxBlocks;

    public PieceTrickMoveBlockSequence(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel("psi.spellparam.max", true).mul(10.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel("psi.spellparam.max", true).sub(1.0).parenthesize().mul(10.5).add(18.0).floor());
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", 13814826, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", 0xD22A2A, false, true);
        this.addParam(this.maxBlocks);
        this.direction = new ParamVector("psi.spellparam.direction", 4117034, false, false);
        this.addParam(this.direction);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException, ArithmeticException {
        super.addToMetadata(meta);
        double maxBlocksVal = SpellHelpers.ensurePositiveAndNonzero(this, this.maxBlocks);
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 10.0));
        meta.addStat(EnumSpellStat.COST, (int)(18.0 + (maxBlocksVal - 1.0) * 10.5));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockPos pushToPos;
        BlockState state;
        Vector3 directionVal = SpellHelpers.getVector3(this, context, this.direction, false, true);
        Vector3 positionVal = SpellHelpers.getVector3(this, context, this.position, true, false);
        Vector3 targetVal = SpellHelpers.getVector3(this, context, this.target, false, false);
        int maxBlocksVal = this.getParamValue(context, this.maxBlocks).intValue();
        Level world = context.focalPoint.level();
        HashMap<BlockPos, BlockState> toSet = new HashMap<BlockPos, BlockState>();
        HashMap<BlockPos, BlockState> toRemove = new HashMap<BlockPos, BlockState>();
        Vector3 directNorm = directionVal.copy().normalize();
        Vector3 targetNorm = targetVal.copy().normalize();
        LinkedHashSet<BlockPos> positions = MathHelper.getBlocksAlongRay(positionVal.toVec3D(), positionVal.copy().add(targetNorm.copy().multiply(maxBlocksVal)).toVec3D(), maxBlocksVal);
        LinkedHashSet<BlockPos> moveableBlocks = new LinkedHashSet<BlockPos>();
        LinkedHashSet<BlockPos> immovableBlocks = new LinkedHashSet<BlockPos>();
        if (context.positionBroken != null) {
            immovableBlocks.add(context.positionBroken.getBlockPos());
        }
        for (BlockPos blockPos : positions) {
            boolean isOffWorld;
            state = world.getBlockState(blockPos);
            if (world.isEmptyBlock(blockPos)) continue;
            if (!(world.getBlockEntity(blockPos) == null && state.getPistonPushReaction() == PushReaction.NORMAL && state.getDestroySpeed((BlockGetter)world, blockPos) != -1.0f && PieceTrickBreakBlock.canHarvestBlock(state, context.caster, world, blockPos, context.getHarvestTool()) && SpellHelpers.isBlockPosInRadius(context, blockPos) && world.mayInteract(context.caster, blockPos))) {
                immovableBlocks.add(blockPos);
                continue;
            }
            pushToPos = blockPos.offset((int)directNorm.x, (int)directNorm.y, (int)directNorm.z);
            boolean bl = isOffWorld = pushToPos.getY() < 0 || pushToPos.getY() > 256;
            if (isOffWorld) {
                immovableBlocks.add(blockPos);
                continue;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, blockPos, state, context.caster);
            if (((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                immovableBlocks.add(blockPos);
                continue;
            }
            moveableBlocks.add(blockPos);
        }
        block1: for (BlockPos blockPos : moveableBlocks) {
            state = world.getBlockState(blockPos);
            pushToPos = blockPos.offset((int)directNorm.x, (int)directNorm.y, (int)directNorm.z);
            BlockState pushToState = world.getBlockState(pushToPos);
            if (immovableBlocks.contains(pushToPos) || immovableBlocks.contains(blockPos)) continue;
            if (moveableBlocks.contains(pushToPos)) {
                BlockPos nextPos = pushToPos;
                while (moveableBlocks.contains(nextPos)) {
                    BlockPos nextPosPushPos = nextPos.offset((int)directNorm.x, (int)directNorm.y, (int)directNorm.z);
                    BlockState nextPosPushPosState = world.getBlockState(nextPosPushPos);
                    if (moveableBlocks.contains(nextPosPushPos)) {
                        nextPos = nextPosPushPos;
                        continue;
                    }
                    if (immovableBlocks.contains(nextPosPushPos) || !world.isEmptyBlock(nextPosPushPos) && !nextPosPushPosState.canBeReplaced()) {
                        continue block1;
                    }
                    break;
                }
            } else if (!world.isEmptyBlock(pushToPos) && !pushToState.canBeReplaced()) continue;
            toRemove.put(blockPos, state);
            toSet.put(pushToPos, state);
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            context.focalPoint.level().removeBlock((BlockPos)entry.getKey(), true);
            context.focalPoint.level().levelEvent(2001, (BlockPos)entry.getKey(), Block.getId((BlockState)((BlockState)entry.getValue())));
        }
        for (Map.Entry entry : toSet.entrySet()) {
            context.focalPoint.level().setBlockAndUpdate((BlockPos)entry.getKey(), (BlockState)entry.getValue());
        }
        return null;
    }
}

