/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.api.matter_fluid.client;

import com.buuz135.replication.Replication;
import com.buuz135.replication.api.matter_fluid.IMatterTank;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class MatterTankScreenAddon
extends BasicScreenAddon {
    private IMatterTank tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;

    public MatterTankScreenAddon(int posX, int posY, IMatterTank tank, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getMatter().isEmpty()) {
            TextureAtlasSprite sprite;
            AbstractTexture texture;
            MatterStack matterStack = this.tank.getMatter();
            double stored = Math.min(this.tank.getMatterAmount(), this.tank.getCapacity());
            double capacity = this.tank.getCapacity();
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = (int)(stored / capacity * (double)(area.height - topBottomPadding));
            ResourceLocation flowing = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"block/matter");
            if (flowing != null && (texture = screen.getMinecraft().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).getSprite(flowing)) != null) {
                float[] color = matterStack.getMatterType().getColor().get();
                guiGraphics.setColor(color[0], color[1], color[2], color[3]);
                RenderSystem.enableBlend();
                MatterTankScreenAddon.drawTiledSprite(guiGraphics, this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST), this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + area.height - topBottomPadding - offset, offset, (int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST)), offset, sprite, sprite.contents().width(), sprite.contents().height(), 0, false, true, false);
                RenderSystem.disableBlend();
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        ITankAsset asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    public List<Component> getTooltipLines() {
        ArrayList<Component> strings = new ArrayList<Component>();
        strings.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.replication.tank.matter").getString())).append((Component)(this.tank.getMatter().isEmpty() ? Component.translatable((String)"tooltip.titanium.tank.empty").withStyle(ChatFormatting.WHITE) : Component.translatable((String)this.tank.getMatter().getTranslationKey()))).withStyle(ChatFormatting.WHITE));
        strings.add((Component)Component.translatable((String)"tooltip.replication.terminal.amount").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(this.tank.getMatter().getAmount()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(this.tank.getCapacity())))).append((Component)Component.translatable((String)"tooltip.replication.tank.unit").withStyle(ChatFormatting.DARK_AQUA)));
        return strings;
    }

    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public static void drawTiledSprite(GuiGraphics guiGraphics, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, boolean blend, boolean right, boolean down) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        if (blend) {
            RenderSystem.enableBlend();
        }
        BufferBuilder vertexBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            float uLocalMax;
            float uLocalMin;
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uLocalDif = uDif * (float)maskRight / (float)textureWidth;
            if (right) {
                uLocalMin = uMin;
                uLocalMax = uMax - uLocalDif;
            } else {
                uLocalMin = uMin + uLocalDif;
                uLocalMax = uMax;
            }
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float vLocalMax;
                float vLocalMin;
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vLocalDif = vDif * (float)maskTop / (float)textureHeight;
                if (down) {
                    vLocalMin = vMin;
                    vLocalMax = vMax - vLocalDif;
                } else {
                    vLocalMin = vMin + vLocalDif;
                    vLocalMax = vMax;
                }
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + textureHeight), (float)zLevel).setUv(uLocalMin, vLocalMax);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + textureHeight), (float)zLevel).setUv(uLocalMax, vLocalMax);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + maskTop), (float)zLevel).setUv(uLocalMax, vLocalMin);
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + maskTop), (float)zLevel).setUv(uLocalMin, vLocalMin);
            }
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
        if (blend) {
            RenderSystem.disableBlend();
        }
    }
}

