/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.container;

import com.buuz135.replication.block.tile.ReplicationTerminalBlockEntity;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.container.addon.UpdatableSlotItemHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import io.netty.buffer.ByteBuf;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ReplicationTerminalContainer
extends AbstractContainerMenu {
    public static DeferredHolder<MenuType<?>, MenuType<?>> TYPE;
    private Inventory inventory;
    private ReplicationTerminalBlockEntity blockEntity;
    private String network;
    private int sortingType;
    private int sortingValue;
    private int matterOpediaSortingType;
    private int matterOpediaSortingValue;
    private BlockPos position;
    private SlotVisualType visualType;

    public ReplicationTerminalContainer(int id, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)TYPE.get(), id);
        Player playerEntity;
        Object provider;
        this.inventory = inventory;
        this.visualType = SlotVisualType.ALL;
        LocatorInstance instance = LocatorFactory.readPacketBuffer((RegistryFriendlyByteBuf)new RegistryFriendlyByteBuf((ByteBuf)buffer, Minecraft.getInstance().level.registryAccess()));
        if (instance != null && (provider = instance.locale(playerEntity = inventory.player).orElse(null)) instanceof ReplicationTerminalBlockEntity) {
            ReplicationTerminalBlockEntity addonProvider = provider;
            this.position = addonProvider.getBlockPos();
            addonProvider.getOutput().getContainerAddons().stream().map(IFactory::create).forEach(containAddon -> {
                containAddon.getSlots().forEach(slot -> this.addSlot((Slot)new UpdatableSlotItemHandler((IItemHandler)addonProvider.getOutput(), slot.getContainerSlot(), slot.x, slot.y){

                    public boolean isActive() {
                        return ReplicationTerminalContainer.this.visualType == SlotVisualType.ALL;
                    }
                }));
                containAddon.getIntReferenceHolders().forEach(x$0 -> this.addDataSlot((DataSlot)x$0));
                containAddon.getIntArrayReferenceHolders().forEach(x$0 -> this.addDataSlots((ContainerData)x$0));
            });
        }
        this.network = buffer.readUtf();
        this.sortingType = buffer.readInt();
        this.sortingValue = buffer.readInt();
        this.matterOpediaSortingType = buffer.readInt();
        this.matterOpediaSortingValue = buffer.readInt();
        this.initInventory();
    }

    public ReplicationTerminalContainer(ReplicationTerminalBlockEntity blockEntity, Inventory inventory, int id) {
        super((MenuType)TYPE.get(), id);
        this.inventory = inventory;
        this.blockEntity = blockEntity;
        Player player = inventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.blockEntity.getTerminalPlayerTracker().addPlayer(serverPlayer);
        }
        this.position = this.blockEntity.getBlockPos();
        this.network = blockEntity.getNetwork().getId();
        this.addExtraSlots();
        this.initInventory();
    }

    public void initInventory() {
        this.addPlayerChestInventory();
        this.addHotbarSlots();
    }

    private void addExtraSlots() {
        if (this.blockEntity != null) {
            this.blockEntity.getOutput().getContainerAddons().stream().map(IFactory::create).forEach(containAddon -> {
                containAddon.getSlots().forEach(slot -> this.addSlot((Slot)new UpdatableSlotItemHandler((IItemHandler)this.blockEntity.getOutput(), slot.getContainerSlot(), slot.x, slot.y){

                    public boolean isActive() {
                        return ReplicationTerminalContainer.this.visualType == SlotVisualType.ALL;
                    }
                }));
                containAddon.getIntReferenceHolders().forEach(x$0 -> this.addDataSlot((DataSlot)x$0));
                containAddon.getIntArrayReferenceHolders().forEach(x$0 -> this.addDataSlots((ContainerData)x$0));
            });
        }
    }

    public void addPlayerChestInventory() {
        Point invPos = new Point(9, 174);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.inventory, j + i * 9 + 9, invPos.x + j * 18 + 2, invPos.y + i * 18 - 3){

                    public boolean isActive() {
                        return ReplicationTerminalContainer.this.visualType == SlotVisualType.ALL || ReplicationTerminalContainer.this.visualType == SlotVisualType.INVENTORY_ONLY;
                    }
                });
            }
        }
    }

    public void addHotbarSlots() {
        Point hotbarPos = new Point(9, 232);
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)this.getPlayerInventory(), k, hotbarPos.x + k * 18 + 2, hotbarPos.y - 3){

                public boolean isActive() {
                    return ReplicationTerminalContainer.this.visualType == SlotVisualType.ALL || ReplicationTerminalContainer.this.visualType == SlotVisualType.INVENTORY_ONLY;
                }
            });
        }
    }

    public Inventory getPlayerInventory() {
        return this.inventory;
    }

    public String getNetwork() {
        return this.network;
    }

    public int getSortingType() {
        return this.sortingType;
    }

    public int getMatterOpediaSortingValue() {
        return this.matterOpediaSortingValue;
    }

    public int getMatterOpediaSortingType() {
        return this.matterOpediaSortingType;
    }

    public int getSortingValue() {
        return this.sortingValue;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int slotPos) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotPos);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int containerSlots = this.slots.size() - 36;
            if (slotPos < containerSlots ? !this.moveItemStackTo(itemstack1, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        if (player instanceof ServerPlayer && this.blockEntity != null) {
            this.blockEntity.getTerminalPlayerTracker().removePlayer((ServerPlayer)player);
        }
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setEnabled(SlotVisualType enabled) {
        this.visualType = enabled;
    }

    public static enum SlotVisualType {
        NONE,
        INVENTORY_ONLY,
        ALL;

    }
}

