/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.client;

import com.mrbysco.simpleteleporters.SimpleTeleporters;
import com.mrbysco.simpleteleporters.block.entity.TeleporterBlockEntity;
import com.mrbysco.simpleteleporters.client.TeleporterBER;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlockEntities;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientHandler {
    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Level level;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null && (level = player.level()) != null) {
                RandomSource random = level.getRandom();
                for (InteractionHand hand : InteractionHand.values()) {
                    BlockPos telePos;
                    ItemStack stack = player.getItemInHand(hand);
                    if (stack.isEmpty() || !stack.is((Item)SimpleTeleportersItems.ENDER_SHARD.get()) && !stack.is((Item)SimpleTeleportersItems.ENHANCED_ENDER_SHARD.get()) || !stack.has(SimpleTeleportersComponents.GLOBAL_POS)) continue;
                    GlobalPos globalPos = (GlobalPos)stack.get(SimpleTeleportersComponents.GLOBAL_POS);
                    ResourceKey dimension = globalPos.dimension();
                    if (!level.dimension().equals(dimension) || (telePos = globalPos.pos()) == null) continue;
                    BlockPos downPos = telePos.below();
                    if (level.getBlockState(downPos).is((Block)SimpleTeleportersBlocks.TELEPORTER.get())) {
                        telePos = downPos;
                    }
                    if (player.blockPosition().distManhattan((Vec3i)telePos) >= 15) continue;
                    level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, random.triangle((double)telePos.getX() + 0.5, 0.2), random.triangle((double)telePos.getY() + 0.5, 0.2), random.triangle((double)telePos.getZ() + 0.5, 0.2), 0.0, 0.0, 0.0);
                    break;
                }
            }
        }
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(SimpleTeleportersBlockEntities.TELEPORTER.get(), TeleporterBER::new);
    }

    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> {
            BlockEntity patt0$temp;
            if (tintIndex == 0 && level != null && pos != null && (patt0$temp = level.getBlockEntity(pos)) instanceof TeleporterBlockEntity) {
                TeleporterBlockEntity teleporter = (TeleporterBlockEntity)patt0$temp;
                return teleporter.getColor().getTextureDiffuseColor();
            }
            return DyeColor.WHITE.getTextureDiffuseColor();
        }, new Block[]{(Block)SimpleTeleportersBlocks.TELEPORTER.get()});
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)SimpleTeleportersItems.ENDER_SHARD.get()), (ResourceLocation)SimpleTeleporters.id("linked"), (stack, level, entity, seed) -> stack.has(SimpleTeleportersComponents.GLOBAL_POS) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)SimpleTeleportersItems.ENHANCED_ENDER_SHARD.get()), (ResourceLocation)SimpleTeleporters.id("linked"), (stack, level, entity, seed) -> stack.has(SimpleTeleportersComponents.GLOBAL_POS) ? 1.0f : 0.0f);
        });
    }
}

