/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sunekaer.toolkit.ToolkitPlatform;
import com.sunekaer.toolkit.utils.ChunkRangeIterator;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockDistributionCommand {
    private static final DecimalFormat FORMATTER = new DecimalFormat("########0.00");
    private static final DecimalFormat COMMA_FORMATTER = new DecimalFormat("#,###");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"oredist").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"area-size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(ctx -> BlockDistributionCommand.getOreDist((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"area-size"))));
    }

    private static int getOreDist(CommandSourceStack source, Player player, int size) {
        ServerLevel level = source.getLevel();
        ChunkRangeIterator iterator = new ChunkRangeIterator((Level)level, player.chunkPosition(), size);
        LinkedHashMultiset blockOccurrences = LinkedHashMultiset.create();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            BlockState state = level.getBlockState(pos);
            if (state.isAir() || state.is(Blocks.BEDROCK) || state.is(Blocks.STONE) || state.is(Blocks.DIRT) || state.is(Blocks.WATER) || !state.is(ToolkitPlatform.getOresTag())) continue;
            ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            blockOccurrences.add((Object)key.toString());
        }
        double sum = blockOccurrences.size();
        if (sum == 0.0) {
            source.sendSuccess(() -> Component.literal((String)"No ores found").withStyle(ChatFormatting.RED), true);
            return 1;
        }
        LinkedHashMultiset sortedSet = LinkedHashMultiset.create(blockOccurrences.entrySet().stream().sorted((a, b) -> Integer.compare(b.getCount(), a.getCount())).toList());
        source.sendSuccess(() -> Component.literal((String)("Block distribution for " + size + "x" + size + " chunks (total: " + COMMA_FORMATTER.format(sum) + ")")).withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        int i = 0;
        for (Multiset.Entry entry : sortedSet) {
            int white = i % 2 == 0 ? Objects.requireNonNull(ChatFormatting.WHITE.getColor()) : 0xC4C3C3;
            int yellow = i % 2 == 0 ? Objects.requireNonNull(ChatFormatting.YELLOW.getColor()) : 14013728;
            MutableComponent component = Component.literal((String)"");
            component.append((Component)Component.literal((String)"[")).withStyle(Style.EMPTY.withColor(yellow));
            component.append((Component)Component.literal((String)COMMA_FORMATTER.format(entry.getCount())).withStyle(Style.EMPTY.withColor(yellow).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)(FORMATTER.format((double)(entry.getCount() * 100) / sum) + "%"))))));
            component.append((Component)Component.literal((String)"]").withStyle(Style.EMPTY.withColor(yellow)));
            component.append((Component)Component.literal((String)(" " + (String)entry.getElement())).withStyle(Style.EMPTY.withColor(white)));
            source.sendSuccess(() -> component, false);
            ++i;
        }
        return 1;
    }
}

