/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.VoxelShapes;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockTinyTorch
extends BlockBase {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", direction -> direction != Direction.DOWN);

    public BlockTinyTorch() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).sound(SoundType.WOOD).strength(0.0f, 0.8f).noCollission());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 12;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case EAST: {
                return VoxelShapes.TinyTorchShapes.TORCH_EAST_AABB;
            }
            case WEST: {
                return VoxelShapes.TinyTorchShapes.TORCH_WEST_AABB;
            }
            case SOUTH: {
                return VoxelShapes.TinyTorchShapes.TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return VoxelShapes.TinyTorchShapes.TORCH_NORTH_AABB;
            }
        }
        return VoxelShapes.TinyTorchShapes.STANDING_AABB;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        return !this.canSurvive(state, (LevelReader)levelAccessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (direction == Direction.UP) {
            return BlockTinyTorch.canSupportCenter((LevelReader)levelReader, (BlockPos)pos.below(), (Direction)Direction.UP);
        }
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = levelReader.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)levelReader, blockpos, direction);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] adirection;
        Level levelreader = context.getLevel();
        BlockState state = this.defaultBlockState();
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        if (this.canSurvive(state, (LevelReader)levelreader, pos)) {
            return (BlockState)state.setValue((Property)FACING, (Comparable)(facing.getAxis() == Direction.Axis.Y ? Direction.UP : facing));
        }
        for (Direction direction : adirection = context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(state = (BlockState)state.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, pos)) continue;
            return state;
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.nextBoolean()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + 0.4;
            double d2 = (double)pos.getZ() + 0.5;
            if (direction.getAxis().isHorizontal()) {
                Direction opposite = direction.getOpposite();
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.35 * (double)opposite.getStepX(), d1 + 0.22, d2 + 0.35 * (double)opposite.getStepZ(), 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + 0.35 * (double)opposite.getStepX(), d1 + 0.22, d2 + 0.35 * (double)opposite.getStepZ(), 0.0, 0.0, 0.0);
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING});
    }
}

