/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.mixin.neoforge.worldgen;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.unification.worldgen.WorldGenBiomeModifier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLifecycleHooks.class})
public class ServerLifecycleHooksMixin {
    @Inject(method={"runModifiers"}, at={@At(value="HEAD")}, remap=false)
    private static void almostunified$injectRegistryAccess(MinecraftServer server, CallbackInfo ci) {
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        Registry biomeModifiers = registryAccess.registryOrThrow(NeoForgeRegistries.Keys.BIOME_MODIFIERS);
        for (BiomeModifier bm : biomeModifiers) {
            if (!(bm instanceof WorldGenBiomeModifier)) continue;
            WorldGenBiomeModifier wgbm = (WorldGenBiomeModifier)bm;
            try {
                WorldGenBiomeModifier.bindUnifier(wgbm, (RegistryAccess)registryAccess);
            }
            catch (Exception e) {
                ResourceLocation id = biomeModifiers.getKey((Object)bm);
                AlmostUnifiedCommon.LOGGER.error("Failed to bind registry access to biome modifier " + String.valueOf(id), (Throwable)e);
            }
        }
    }
}

