/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.aether;

import com.aetherteam.aether.effect.AetherEffects;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.affix.AttributeAffix;
import dev.shadowsoffire.apotheosis.affix.effect.DamageReductionAffix;
import dev.shadowsoffire.apotheosis.affix.effect.EnchantmentAffix;
import dev.shadowsoffire.apotheosis.affix.effect.MobEffectAffix;
import dev.shadowsoffire.apotheosis.data.AffixProvider;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class AetherAffixProvider
extends AffixProvider {
    String mod = "aether";

    public AetherAffixProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public String getName() {
        return "Aether Affixes";
    }

    public void generate() {
        LootRarity common = AetherAffixProvider.rarity("common");
        LootRarity uncommon = AetherAffixProvider.rarity("uncommon");
        LootRarity rare = AetherAffixProvider.rarity("rare");
        LootRarity epic = AetherAffixProvider.rarity("epic");
        LootRarity mythic = AetherAffixProvider.rarity("mythic");
        LootRarity ancient = AetherAffixProvider.ancientRarity("ancient");
        this.addMobEffect("armor", "inebriation", (Holder<MobEffect>)AetherEffects.INEBRIATION, MobEffectAffix.Target.HURT_ATTACKER, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.LEGGINGS, Apoth.LootCategories.BOOTS}).stacking().limit(3).value(rare, 80, 160, 0, 80).value(epic, 120, 200, 0, 80).value(mythic, 160, 240, StepFunction.fromBounds((float)0.0f, (float)1.0f, (float)0.125f), 80));
        this.addAncientMobEffect("armor", "inebriation", (Holder<MobEffect>)AetherEffects.INEBRIATION, MobEffectAffix.Target.HURT_ATTACKER, b -> ((MobEffectAffix.Builder)b.definition(AffixType.BASIC_EFFECT, 25, 0.1f)).categories(new LootCategory[]{Apoth.LootCategories.LEGGINGS, Apoth.LootCategories.BOOTS}).stacking().limit(3).value(ancient, 200, 280, StepFunction.fromBounds((float)1.0f, (float)2.0f, (float)0.125f), 80));
    }

    public void addEnchantment(String type, String name, Holder<Enchantment> enchantment, EnchantmentAffix.Mode mode, UnaryOperator<EnchantmentAffix.Builder> config) {
        EnchantmentAffix.Builder builder = new EnchantmentAffix.Builder(enchantment, mode);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/enchantment/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    public void addMobEffect(String type, String name, Holder<MobEffect> effect, MobEffectAffix.Target target, UnaryOperator<MobEffectAffix.Builder> config) {
        MobEffectAffix.Builder builder = new MobEffectAffix.Builder(effect, target);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/mob_effect/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    public void addDamageReduction(String type, String name, DamageReductionAffix.DamageType dType, UnaryOperator<DamageReductionAffix.Builder> config) {
        DamageReductionAffix.Builder builder = new DamageReductionAffix.Builder(dType);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/dmg_reduction/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    public void addAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod)});
    }

    public void addAncientEnchantment(String type, String name, Holder<Enchantment> enchantment, EnchantmentAffix.Mode mode, UnaryOperator<EnchantmentAffix.Builder> config) {
        EnchantmentAffix.Builder builder = new EnchantmentAffix.Builder(enchantment, mode);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/enchantment/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    public void addAncientMobEffect(String type, String name, Holder<MobEffect> effect, MobEffectAffix.Target target, UnaryOperator<MobEffectAffix.Builder> config) {
        MobEffectAffix.Builder builder = new MobEffectAffix.Builder(effect, target);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/mob_effect/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    public void addAncientDamageReduction(String type, String name, DamageReductionAffix.DamageType dType, UnaryOperator<DamageReductionAffix.Builder> config) {
        DamageReductionAffix.Builder builder = new DamageReductionAffix.Builder(dType);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/dmg_reduction/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    public void addAncientAttribute(String type, String name, Holder<Attribute> attribute, AttributeModifier.Operation op, UnaryOperator<AttributeAffix.Builder> config) {
        AttributeAffix.Builder builder = new AttributeAffix.Builder(attribute, op);
        config.apply(builder);
        this.addConditionally(ApothicCompats.loc(type + "/attribute/ancient/" + name), (CodecProvider)builder.build(), new ICondition[]{new ModLoadedCondition(this.mod), new ModLoadedCondition("ancientreforging")});
    }

    private static LootRarity rarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(Apotheosis.loc((String)path))));
    }

    private static LootRarity ancientRarity(String path) {
        return (LootRarity)Preconditions.checkNotNull((Object)((LootRarity)RarityRegistry.INSTANCE.getValue(AncientReforging.loc((String)path))));
    }
}

