/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.block;

import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.menu.locator.MenuLocators;
import es.degrassi.appexp.block.entity.ExperienceConverterEntity;
import es.degrassi.appexp.definition.AExpComponents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExperienceConverterBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty light = IntegerProperty.create((String)"light", (int)0, (int)15);
    private static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> spawnPredicate = (state, level, pos, type) -> {
        ExperienceConverterBlock machineBlock;
        Block patt0$temp;
        return state.isFaceSturdy(level, pos, Direction.UP) && (patt0$temp = state.getBlock()) instanceof ExperienceConverterBlock && (machineBlock = (ExperienceConverterBlock)patt0$temp).getLightEmission(state, level, pos) < 14;
    };

    public ExperienceConverterBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).dynamicShape().noOcclusion().requiresCorrectToolForDrops().strength(5.0f, 6.0f).lightLevel(state -> (Integer)state.getValue((Property)light)).isValidSpawn(spawnPredicate));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)light, (Comparable)Integer.valueOf(0));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{light});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExperienceConverterEntity) {
            ExperienceConverterEntity entity = (ExperienceConverterEntity)blockEntity;
            if (stack.is(Items.GLASS_BOTTLE)) {
                long extracted = entity.getExperienceTank().extractExperience(0, 7L, true);
                if (extracted == 7L) {
                    entity.getExperienceTank().extractExperience(0, 7L, false);
                    stack.consume(1, (LivingEntity)player);
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE));
                    return ItemInteractionResult.CONSUME;
                }
                return ItemInteractionResult.FAIL;
            }
            if (stack.is(Items.EXPERIENCE_BOTTLE)) {
                long inserted = entity.getExperienceTank().receiveExperience(0, 7L, true);
                if (inserted == 7L) {
                    entity.getExperienceTank().receiveExperience(0, 7L, false);
                    stack.consume(1, (LivingEntity)player);
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                    return ItemInteractionResult.CONSUME;
                }
                return ItemInteractionResult.FAIL;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.makeShape();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExperienceConverterEntity) {
            ExperienceConverterEntity entity = (ExperienceConverterEntity)blockEntity;
            entity.getExperienceTank().setExperience(0, ((Long)stack.getOrDefault(AExpComponents.EXPERIENCE_AMOUNT, (Object)0L)).longValue());
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ExperienceConverterEntity) {
            ExperienceConverterEntity entity = (ExperienceConverterEntity)blockEntity;
            stack.set(AExpComponents.EXPERIENCE_AMOUNT, (Object)entity.getExperience());
        }
        return stack;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ExperienceConverterEntity) {
            ExperienceConverterEntity machine = (ExperienceConverterEntity)te;
            machine.openMenu(player, MenuLocators.forBlockEntity((BlockEntity)te));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ExperienceConverterEntity(pos, state);
    }

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.create((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.create((double)0.375, (double)0.875, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.create((double)0.9375, (double)0.75, (double)0.9375, (double)0.0625, (double)0.0, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.create((double)0.4375, (double)0.75, (double)0.4375, (double)0.5625, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.create((double)0.375, (double)0.75, (double)0.375, (double)0.625, (double)0.875, (double)0.625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (l, pos, s, be) -> {
            ServerTickingBlockEntity tank;
            if (!l.isClientSide() && be instanceof ServerTickingBlockEntity) {
                tank = (ServerTickingBlockEntity)be;
                tank.serverTick();
            }
            if (l.isClientSide() && be instanceof ClientTickingBlockEntity) {
                tank = (ClientTickingBlockEntity)be;
                tank.clientTick();
            }
        };
    }
}

