/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.data;

import appeng.core.AppEng;
import appeng.core.definitions.ItemDefinition;
import appeng.items.storage.StorageTier;
import es.degrassi.appexp.AppliedExperienced;
import es.degrassi.appexp.definition.AExpItems;
import es.degrassi.appexp.item.ExperiencePortableCellItem;
import es.degrassi.appexp.item.ExperienceStorageCell;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelProvider
extends net.neoforged.neoforge.client.model.generators.ItemModelProvider {
    public ItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "appex", existingFileHelper);
    }

    protected void registerModels() {
        ItemDefinition<Item> housing = AExpItems.EXPERIENCE_CELL_HOUSING;
        ((ItemModelBuilder)this.withExistingParent(housing.id().getPath(), this.mcLoc("item/generated"))).texture("layer0", AppliedExperienced.id("item/" + housing.id().getPath()));
        AExpItems.getCells().forEach(cell -> {
            this.cell((ItemDefinition<?>)cell, "item/" + cell.id().getPath());
            this.driveCell(cell.id().getPath(), this.offsetByTier(((ExperienceStorageCell)cell.get()).getTier()));
        });
        AExpItems.getPortables().forEach(cell -> this.portableCell((ItemDefinition<?>)cell, ((ExperiencePortableCellItem)cell.get()).getTier().namePrefix()));
        ResourceLocation tunnel = AppliedExperienced.id("part/p2p_tunnel_experience");
        ((ItemModelBuilder)this.withExistingParent("item/experience_p2p_tunnel", AppEng.makeId((String)"item/p2p_tunnel_base"))).texture("type", tunnel);
        ((ItemModelBuilder)this.withExistingParent("part/experience_p2p_tunnel", AppEng.makeId((String)"part/p2p/p2p_tunnel_base"))).texture("type", tunnel);
        ((ItemModelBuilder)this.withExistingParent("part/experience_acceptor", AppEng.makeId((String)"part/energy_acceptor"))).texture("front", "block/experience_acceptor");
        ((ItemModelBuilder)this.withExistingParent("item/cable_experience_acceptor", AppEng.makeId((String)"item/cable_energy_acceptor"))).texture("front", "block/experience_acceptor");
    }

    private int offsetByTier(StorageTier tier) {
        return switch (tier.bytes()) {
            case 1024 -> 0;
            case 4096 -> 2;
            case 16384 -> 4;
            case 65536 -> 6;
            case 262144 -> 8;
            default -> 12;
        };
    }

    private void cell(ItemDefinition<?> cell, String background) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(cell.id().getPath(), this.mcLoc("item/generated"))).texture("layer0", AppliedExperienced.id(background))).texture("layer1", AppEng.makeId((String)"item/storage_cell_led"));
    }

    private void portableCell(ItemDefinition<?> portable, String tier) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(portable.id().getPath(), this.mcLoc("item/generated"))).texture("layer0", AppliedExperienced.id("item/portable_experience_cell_housing"))).texture("layer1", AppEng.makeId((String)"item/portable_cell_led"))).texture("layer2", AppEng.makeId((String)"item/portable_cell_screen"))).texture("layer3", AppEng.makeId((String)("item/portable_cell_side_" + tier)));
    }

    private void driveCell(String cell, int offset) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("block/drive/cells/" + cell)).ao(false)).texture("cell", "block/drive/drive_cells")).texture("particle", "block/drive/drive_cells")).element().to(6.0f, 2.0f, 2.0f).face(Direction.NORTH).uvs(0.0f, (float)offset, 6.0f, (float)(offset + 2)).end().face(Direction.UP).uvs(6.0f, (float)offset, 0.0f, (float)(offset + 2)).end().face(Direction.DOWN).uvs(6.0f, (float)offset, 0.0f, (float)(offset + 2)).end().faces((dir, builder) -> builder.texture("#cell").cullface(Direction.NORTH).end()).end();
    }
}

