/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.data;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.items.storage.StorageTier;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import es.degrassi.appexp.AppliedExperienced;
import es.degrassi.appexp.definition.AExpBlocks;
import es.degrassi.appexp.definition.AExpItems;
import es.degrassi.appexp.item.ExperiencePortableCellItem;
import es.degrassi.appexp.item.ExperienceStorageCell;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider {
    public RecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, () -> AExpItems.EXPERIENCE_CELL_HOUSING.get()).pattern("QRQ").pattern("R R").pattern("OOO").define(Character.valueOf('Q'), (ItemLike)AEBlocks.QUARTZ_GLASS).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('O'), (ItemLike)Items.EXPERIENCE_BOTTLE).unlockedBy("has_dusts/redstone", RecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(output, AppliedExperienced.id("experience_cell_housing"));
        Item housing = AExpItems.EXPERIENCE_CELL_HOUSING.get();
        AExpItems.getCells().forEach(cell -> {
            Item component = RecipeProvider.cellComponent(((ExperienceStorageCell)cell.get()).getTier());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, () -> ((ItemDefinition)cell).get()).requires((ItemLike)housing).requires((ItemLike)component).unlockedBy("has_cell_component_" + ((ExperienceStorageCell)cell.get()).getTier().namePrefix(), RecipeProvider.has((ItemLike)cell)).unlockedBy("has_experience_housing", RecipeProvider.has((ItemLike)housing)).save(output);
            output.accept(cell.id().withSuffix("_disassembly"), (Recipe)new StorageCellDisassemblyRecipe(cell.asItem(), List.of(component.getDefaultInstance(), housing.getDefaultInstance())), null);
        });
        AExpItems.getPortables().forEach(portable -> {
            Item component = RecipeProvider.cellComponent(((ExperiencePortableCellItem)portable.get()).getTier());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, () -> ((ItemDefinition)portable).get()).requires((ItemLike)AEBlocks.ME_CHEST).requires((ItemLike)component).requires((ItemLike)AEBlocks.ENERGY_CELL).requires((ItemLike)housing).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)housing).getPath(), RecipeProvider.has((ItemLike)housing)).unlockedBy("has_energy_cell", RecipeProvider.has((ItemLike)AEBlocks.ENERGY_CELL)).save(output);
            output.accept(portable.id().withSuffix("_disassembly"), (Recipe)new StorageCellDisassemblyRecipe(portable.asItem(), List.of(component.getDefaultInstance(), housing.getDefaultInstance(), AEBlocks.ME_CHEST.stack(), AEBlocks.ENERGY_CELL.stack())), null);
        });
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AExpBlocks.EXPERIENCE_CONVERTER).pattern("ppp").pattern("ede").pattern("ccc").define(Character.valueOf('p'), TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"planks"))).define(Character.valueOf('d'), (ItemLike)AEItems.CELL_COMPONENT_64K).define(Character.valueOf('c'), TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)"c:glass_panes"))).define(Character.valueOf('e'), (ItemLike)Items.EXPERIENCE_BOTTLE).unlockedBy("has_experience_bottle", RecipeProvider.has((ItemLike)Items.EXPERIENCE_BOTTLE)).save(output, AppliedExperienced.id("experience_converter"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AExpBlocks.EXPERIENCE_ACCEPTOR).pattern("ede").pattern("dad").pattern("ede").define(Character.valueOf('a'), (ItemLike)AEBlocks.ENERGY_ACCEPTOR).define(Character.valueOf('d'), (ItemLike)AEItems.CELL_COMPONENT_1K).define(Character.valueOf('e'), (ItemLike)Items.EXPERIENCE_BOTTLE).unlockedBy("has_experience_bottle", RecipeProvider.has((ItemLike)Items.EXPERIENCE_BOTTLE)).save(output, AppliedExperienced.id("experience_acceptor_1"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AExpBlocks.EXPERIENCE_ACCEPTOR).pattern("ded").pattern("eae").pattern("ded").define(Character.valueOf('a'), (ItemLike)AEBlocks.ENERGY_ACCEPTOR).define(Character.valueOf('d'), (ItemLike)AEItems.CELL_COMPONENT_1K).define(Character.valueOf('e'), (ItemLike)Items.EXPERIENCE_BOTTLE).unlockedBy("has_experience_bottle", RecipeProvider.has((ItemLike)Items.EXPERIENCE_BOTTLE)).save(output, AppliedExperienced.id("experience_acceptor_2"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AExpItems.EXPERIENCE_ACCEPTOR_PART).requires(AExpBlocks.EXPERIENCE_ACCEPTOR).unlockedBy("has_experience_acceptor", RecipeProvider.has(AExpBlocks.EXPERIENCE_ACCEPTOR)).save(output, AppliedExperienced.id("cable_experience_acceptor"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AExpBlocks.EXPERIENCE_ACCEPTOR).requires(AExpItems.EXPERIENCE_ACCEPTOR_PART).unlockedBy("has_experience_acceptor", RecipeProvider.has(AExpBlocks.EXPERIENCE_ACCEPTOR)).save(output, AppliedExperienced.id("experience_acceptor_from_part"));
    }

    private static Item cellComponent(StorageTier tier) {
        return (Item)tier.componentSupplier().get();
    }
}

