/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import es.degrassi.appexp.api.item.IExperienceCellItem;
import es.degrassi.appexp.definition.AExpComponents;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.appexp.me.key.ExperienceKeyType;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExperienceCellInventory
implements StorageCell {
    private final IExperienceCellItem cell;
    private final ItemStack stack;
    private final ISaveProvider container;
    private long amount;
    private boolean isPersisted = true;

    public ExperienceCellInventory(IExperienceCellItem cell, ItemStack stack, ISaveProvider container) {
        this.cell = cell;
        this.stack = stack;
        this.container = container;
        this.amount = (Long)stack.getOrDefault(AExpComponents.EXPERIENCE_AMOUNT, (Object)0L);
    }

    public long getTotalBytes() {
        return this.cell.getTotalBytes();
    }

    public long getUsedBytes() {
        int amountPerByte = ExperienceKeyType.TYPE.getAmountPerByte();
        return (this.amount + (long)amountPerByte - 1L) / (long)amountPerByte;
    }

    public long getMaxAmount() {
        return this.cell.getTotalBytes() * (long)ExperienceKeyType.TYPE.getAmountPerByte();
    }

    public CellState getStatus() {
        if (this.amount == 0L) {
            return CellState.EMPTY;
        }
        if (this.amount == this.getMaxAmount()) {
            return CellState.FULL;
        }
        if (this.amount > this.getMaxAmount() / 2L) {
            return CellState.TYPES_FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cell.getIdleDrain();
    }

    public IUpgradeInventory getUpgrades() {
        return this.cell.getUpgrades(this.stack);
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof ExperienceKey)) {
            return 0L;
        }
        long inserted = Math.min(amount, Math.max(0L, this.getMaxAmount() - this.amount));
        if (mode == Actionable.MODULATE) {
            this.amount += inserted;
            this.saveChanges();
        }
        return this.getUpgrades().isInstalled((ItemLike)AEItems.VOID_CARD) ? amount : inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentAmount = this.amount;
        if (this.amount > 0L && Objects.equals((Object)ExperienceKey.KEY, what)) {
            if (mode == Actionable.MODULATE) {
                this.amount = Math.max(0L, this.amount - extractAmount);
                this.saveChanges();
            }
            return Math.min(extractAmount, currentAmount);
        }
        return 0L;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.amount < 0L) {
            this.stack.remove(AExpComponents.EXPERIENCE_AMOUNT);
        } else {
            this.stack.set(AExpComponents.EXPERIENCE_AMOUNT, (Object)this.amount);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.amount > 0L) {
            out.add((AEKey)ExperienceKey.KEY, this.amount);
        }
    }

    public Component getDescription() {
        return this.stack.getHoverName();
    }
}

