/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.client.screen.perk.PerkTreeScreen;
import com.github.ars_affinity.client.screen.perk.SchoolColorHelper;
import com.github.ars_affinity.perk.PerkTreeManager;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;

public class AffinityScreen
extends Screen {
    private static final int BACKGROUND_HEIGHT = 194;
    private static final int ICON_SIZE = 16;
    private static final int PERK_NODE_SIZE = 24;
    private static final ResourceLocation PERK_TREE_BACKGROUND = ArsAffinity.prefix("textures/gui/perk_tree_background.png");
    private static final ResourceLocation PERK_BACKGROUND_TEXTURE = ArsAffinity.prefix("textures/gui/perk_background.png");
    private static final ResourceLocation PERK_BORDER_TEXTURE = ArsAffinity.prefix("textures/gui/perk_border.png");
    private static final ResourceLocation AFFINITY_FRAME = ArsAffinity.prefix("textures/gui/affinity_frame.png");
    private final Player player;
    private final boolean showBackButton;
    private final Screen parentScreen;
    private final List<SpellSchool> schools = List.of(SpellSchools.ELEMENTAL_EARTH, SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_FIRE, SpellSchools.NECROMANCY, SpellSchools.ELEMENTAL_AIR, SpellSchools.CONJURATION, SpellSchools.ELEMENTAL_WATER, SpellSchools.ABJURATION);
    private SpellSchool hoveredSchool = null;
    private SpellSchool previousHoveredSchool = null;
    private long fadeStartTime = 0L;
    private boolean isFadingIn = false;
    private boolean isFadingOut = false;
    private boolean isAnimating = false;
    private boolean helpButtonHovered = false;

    public AffinityScreen(Player player) {
        this(player, false, null);
    }

    public AffinityScreen(Player player, boolean showBackButton) {
        this(player, showBackButton, null);
    }

    public AffinityScreen(Player player, boolean showBackButton, Screen parentScreen) {
        super((Component)Component.translatable((String)"ars_affinity.screen.affinity.title"));
        this.player = player;
        this.showBackButton = showBackButton;
        this.parentScreen = parentScreen;
    }

    private ResourceLocation getConstellationTexture(SpellSchool school) {
        String schoolName = school.getId();
        return ArsAffinity.prefix("textures/gui/c_" + schoolName + ".png");
    }

    private void updateConstellationAnimation() {
        if (this.hoveredSchool != this.previousHoveredSchool && !this.isAnimating) {
            long currentTime = System.currentTimeMillis();
            if (this.hoveredSchool != null) {
                this.fadeStartTime = currentTime;
                this.isFadingIn = true;
                this.isFadingOut = false;
                this.isAnimating = true;
                this.previousHoveredSchool = this.hoveredSchool;
            } else {
                this.fadeStartTime = currentTime;
                this.isFadingIn = false;
                this.isFadingOut = true;
                this.isAnimating = true;
            }
        }
    }

    private void renderConstellation(GuiGraphics guiGraphics, int centerX, int centerY) {
        SpellSchool schoolToRender;
        if (this.hoveredSchool == null && !this.isFadingOut) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        float alpha = 0.0f;
        if (this.isFadingIn) {
            fadeElapsed = currentTime - this.fadeStartTime;
            fadeProgress = Math.min((float)fadeElapsed / 200.0f, 1.0f);
            alpha = fadeProgress * 0.8f;
            if (fadeProgress >= 1.0f) {
                this.isFadingIn = false;
                this.isAnimating = false;
            }
        } else if (this.isFadingOut) {
            fadeElapsed = currentTime - this.fadeStartTime;
            fadeProgress = Math.min((float)fadeElapsed / 200.0f, 1.0f);
            alpha = (1.0f - fadeProgress) * 0.8f;
            if (fadeProgress >= 1.0f) {
                this.isFadingOut = false;
                this.isAnimating = false;
                this.previousHoveredSchool = null;
            }
        } else {
            alpha = 0.8f;
        }
        if (alpha <= 0.0f) {
            if (this.isFadingOut) {
                this.isFadingOut = false;
                this.previousHoveredSchool = null;
            }
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        SpellSchool spellSchool = schoolToRender = this.hoveredSchool != null ? this.hoveredSchool : this.previousHoveredSchool;
        if (schoolToRender == null) {
            return;
        }
        ResourceLocation constellationTexture = this.getConstellationTexture(schoolToRender);
        int constellationSize = 128;
        int constellationX = centerX - constellationSize / 2;
        int constellationY = centerY - constellationSize / 2;
        guiGraphics.blit(constellationTexture, constellationX, constellationY, 0.0f, 0.0f, constellationSize, constellationSize, constellationSize, constellationSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 194;
        int panelHeight = 194;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        guiGraphics.enableScissor(panelX, panelY, panelX + panelWidth, panelY + panelHeight);
        this.renderParallaxBackground(guiGraphics, centerX, centerY);
        this.updateConstellationAnimation();
        this.renderConstellation(guiGraphics, centerX, centerY);
        this.renderSchoolOctagon(guiGraphics, centerX, centerY, mouseX, mouseY);
        guiGraphics.disableScissor();
        this.renderFrameOverlay(guiGraphics);
        if (this.showBackButton) {
            this.renderBackButtonIcon(guiGraphics, mouseX, mouseY);
        }
        this.renderHelpButton(guiGraphics, mouseX, mouseY);
        if (this.helpButtonHovered) {
            this.renderHelpTooltip(guiGraphics, mouseX, mouseY);
        }
        if (this.hoveredSchool != null) {
            this.renderSchoolInfo(guiGraphics, centerX, centerY);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 194;
        int panelHeight = 194;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        guiGraphics.enableScissor(panelX, panelY, panelX + panelWidth, panelY + panelHeight);
        this.renderParallaxBackground(guiGraphics, centerX, centerY);
        guiGraphics.disableScissor();
    }

    private void renderParallaxBackground(GuiGraphics guiGraphics, int centerX, int centerY) {
        int textureSize = 410;
        for (int x = -textureSize; x < this.width + textureSize; x += textureSize) {
            for (int y = -textureSize; y < this.height + textureSize; y += textureSize) {
                guiGraphics.blit(PERK_TREE_BACKGROUND, x, y, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
            }
        }
    }

    private void renderSchoolOctagon(GuiGraphics guiGraphics, int centerX, int centerY, int mouseX, int mouseY) {
        int iconRadius = 62;
        int numSchools = this.schools.size();
        this.hoveredSchool = null;
        for (int i = 0; i < numSchools; ++i) {
            SpellSchool school = this.schools.get(i);
            double angleDeg = -45.0 + (double)i * 360.0 / (double)numSchools;
            double angleRad = Math.toRadians(angleDeg);
            int iconX = (int)((double)centerX + 62.0 * Math.cos(angleRad)) - 8;
            int iconY = (int)((double)centerY + 62.0 * Math.sin(angleRad) - 8.0) + 1;
            this.renderSchoolIcon(guiGraphics, school, iconX, iconY);
            int nodeX = iconX - 4;
            int nodeY = iconY - 4;
            if (mouseX < nodeX || mouseX >= nodeX + 24 || mouseY < nodeY || mouseY >= nodeY + 24) continue;
            this.hoveredSchool = school;
        }
    }

    private void renderSchoolIcon(GuiGraphics guiGraphics, SpellSchool school, int x, int y) {
        int nodeX = x - 4;
        int nodeY = y - 4;
        PlayerAffinityData affinityData = PlayerAffinityDataHelper.getPlayerAffinityData(this.player);
        boolean hasAvailablePoints = affinityData != null && affinityData.getAvailablePoints(school) > 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(PERK_BACKGROUND_TEXTURE, nodeX, nodeY, 0.0f, 0.0f, 24, 24, 24, 24);
        if (hasAvailablePoints) {
            int schoolColor = SchoolColorHelper.getSchoolColor(school);
            RenderSystem.setShaderColor((float)((float)(schoolColor >> 16 & 0xFF) / 255.0f), (float)((float)(schoolColor >> 8 & 0xFF) / 255.0f), (float)((float)(schoolColor & 0xFF) / 255.0f), (float)1.0f);
            guiGraphics.blit(PERK_BORDER_TEXTURE, nodeX, nodeY, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation iconTexture = school.getTexturePath();
        guiGraphics.blit(iconTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private void renderFrameOverlay(GuiGraphics guiGraphics) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 194;
        int panelHeight = 194;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int frameWidth = 198;
        int frameHeight = 198;
        int frameX = panelX - 2;
        int frameY = panelY - 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.1f);
        guiGraphics.blit(AFFINITY_FRAME, frameX, frameY, 0.0f, 0.0f, frameWidth, frameHeight, frameWidth, frameHeight);
        guiGraphics.pose().popPose();
    }

    private void renderSchoolInfo(GuiGraphics guiGraphics, int centerX, int centerY) {
        PlayerAffinityData affinityData = PlayerAffinityDataHelper.getPlayerAffinityData(this.player);
        if (affinityData == null) {
            return;
        }
        int totalPoints = affinityData.getSchoolPoints(this.hoveredSchool);
        int maxPoints = PerkTreeManager.getMaxPointsForSchool(this.hoveredSchool);
        float currentPercentage = affinityData.getSchoolPercentage(this.hoveredSchool);
        int progressPercent = 0;
        if (maxPoints > 0) {
            if (totalPoints >= maxPoints) {
                progressPercent = 100;
            } else {
                int nextPointThreshold = totalPoints;
                int thresholdInterval = 100 / maxPoints;
                int nextPointEnd = (nextPointThreshold + 1) * thresholdInterval;
                int nextPointStart = nextPointThreshold * thresholdInterval;
                if (nextPointEnd > nextPointStart && currentPercentage >= (float)nextPointStart) {
                    float progressInNextPoint = (currentPercentage - (float)nextPointStart) / (float)(nextPointEnd - nextPointStart);
                    progressPercent = (int)Math.floor(progressInNextPoint * 100.0f);
                } else if (currentPercentage < (float)nextPointStart) {
                    progressPercent = 0;
                }
            }
        }
        String schoolName = this.hoveredSchool.getTextComponent().getString();
        String progressText = progressPercent + "%";
        String perksText = totalPoints + "/" + maxPoints;
        Objects.requireNonNull(this.font);
        int startY = centerY - 3 * 9 / 2;
        int nameWidth = this.font.width(schoolName);
        guiGraphics.drawString(this.font, schoolName, centerX - nameWidth / 2, startY, 0xFFFFFF, false);
        int progressWidth = this.font.width(progressText);
        int n = centerX - progressWidth / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, progressText, n, startY + 9, 0xFFFFFF, false);
        int perksWidth = this.font.width(perksText);
        int n2 = centerX - perksWidth / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, perksText, n2, startY + 2 * 9, 0xFFFFFF, false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int centerX = this.width / 2;
            int centerY = this.height / 2;
            int iconRadius = 62;
            int numSchools = this.schools.size();
            for (int i = 0; i < numSchools; ++i) {
                SpellSchool school = this.schools.get(i);
                double angleDeg = -45.0 + (double)i * 360.0 / (double)numSchools;
                double angleRad = Math.toRadians(angleDeg);
                int iconX = (int)((double)centerX + 62.0 * Math.cos(angleRad)) - 8;
                int iconY = (int)((double)centerY + 62.0 * Math.sin(angleRad) - 8.0) + 1;
                int nodeX = iconX - 4;
                int nodeY = iconY - 4;
                if (!(mouseX >= (double)nodeX) || !(mouseX < (double)(nodeX + 24)) || !(mouseY >= (double)nodeY) || !(mouseY < (double)(nodeY + 24))) continue;
                this.minecraft.setScreen((Screen)new PerkTreeScreen(this.player, school, this));
                return true;
            }
        }
        if (this.showBackButton && this.handleBackButtonClick((int)mouseX, (int)mouseY)) {
            return true;
        }
        if (this.handleHelpButtonClick((int)mouseX, (int)mouseY)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void renderBackButtonIcon(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 194;
        int panelHeight = 194;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonWidth = DocAssets.ARROW_BACK.width();
        int buttonHeight = DocAssets.ARROW_BACK.height();
        int buttonX = panelX + 10;
        int buttonY = panelY + 10;
        boolean isHovered = mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
        DocAssets.BlitInfo backIcon = isHovered ? DocAssets.ARROW_BACK_HOVER : DocAssets.ARROW_BACK;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.15f);
        guiGraphics.blit(backIcon.location(), buttonX, buttonY, (float)backIcon.u(), (float)backIcon.v(), buttonWidth, buttonHeight, backIcon.width(), backIcon.height());
        guiGraphics.pose().popPose();
    }

    private boolean handleBackButtonClick(int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 194;
        int panelHeight = 194;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonWidth = DocAssets.ARROW_BACK.width();
        int buttonHeight = DocAssets.ARROW_BACK.height();
        int buttonX = panelX + 10;
        int buttonY = panelY + 10;
        if (mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight) {
            if (this.parentScreen != null) {
                this.minecraft.setScreen(this.parentScreen);
            } else {
                this.onClose();
            }
            return true;
        }
        return false;
    }

    private void renderHelpButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 194;
        int panelHeight = 194;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonSize = 16;
        int buttonX = panelX + panelWidth - buttonSize - 10;
        int buttonY = panelY + 10;
        this.helpButtonHovered = mouseX >= buttonX && mouseX < buttonX + buttonSize && mouseY >= buttonY && mouseY < buttonY + buttonSize;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.1f);
        int textColor = this.helpButtonHovered ? -1 : -3355444;
        guiGraphics.drawCenteredString(this.font, "?", buttonX + buttonSize / 2, buttonY + 4, textColor);
        guiGraphics.pose().popPose();
    }

    private void renderHelpTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        List<Component> tooltipLines = List.of(Component.literal((String)"\u00a76Affinity Progression"), Component.literal((String)""), Component.literal((String)"\u00a77Casting spells builds affinity"), Component.literal((String)"\u00a77with their respective schools."), Component.literal((String)""), Component.literal((String)"\u00a77Higher affinity unlocks powerful"), Component.literal((String)"\u00a77perks and abilities related to"), Component.literal((String)"\u00a77that school's magic."), Component.literal((String)""), Component.literal((String)"\u00a77As you progress, you'll gain"), Component.literal((String)"\u00a77increased spell power and"), Component.literal((String)"\u00a77resistance for that school,"), Component.literal((String)"\u00a77plus unique passive abilities."), Component.literal((String)""), Component.literal((String)"\u00a77Click on a school to view"), Component.literal((String)"\u00a77detailed perks and abilities."));
        List<FormattedCharSequence> formattedLines = tooltipLines.stream().map(component -> component.getVisualOrderText()).toList();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
        guiGraphics.renderTooltip(this.font, formattedLines, mouseX + 10, mouseY - 10);
        guiGraphics.pose().popPose();
    }

    private boolean handleHelpButtonClick(int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 194;
        int panelHeight = 194;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonSize = 16;
        int buttonX = panelX + panelWidth - buttonSize - 10;
        int buttonY = panelY + 10;
        return mouseX >= buttonX && mouseX < buttonX + buttonSize && mouseY >= buttonY && mouseY < buttonY + buttonSize;
    }
}

