/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.common.ability.AbstractDashAbility;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.registry.ModPotions;
import com.github.ars_affinity.registry.ModSounds;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.common.block.MagicFire;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FireDashHelper
extends AbstractDashAbility {
    private static final FireDashHelper INSTANCE = new FireDashHelper();

    public static void triggerAbility(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        INSTANCE.executeAbility(player, perk);
    }

    @Override
    protected Holder<MobEffect> getCooldownEffect() {
        return ModPotions.FIRE_DASH_COOLDOWN_EFFECT;
    }

    @Override
    protected double getDashSpeedMultiplier() {
        return 0.75;
    }

    @Override
    protected void onHitTarget(ServerPlayer player, LivingEntity target, Vec3 startPos, Vec3 endPos, Vec3 dashDir, int index) {
        if (!player.isAlive() || !target.isAlive()) {
            return;
        }
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        ArsAffinity.LOGGER.info("FIRE DASH: igniting target immediately name={}", (Object)target.getName().getString());
        this.igniteTargetFallback(player, target);
    }

    private void igniteTargetFallback(ServerPlayer player, LivingEntity target) {
        IManaCap manaCap = (IManaCap)player.getCapability(CapabilityRegistry.MANA_CAPABILITY);
        int maxMana = manaCap != null ? manaCap.getMaxMana() : 100;
        int seconds = Math.max(3, Math.min(15, maxMana / 100));
        target.setRemainingFireTicks(seconds * 20);
    }

    @Override
    protected void spawnTrailParticle(ServerLevel level, double x, double y, double z) {
        level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 2, 0.02, 0.02, 0.02, 0.02);
    }

    @Override
    protected void spawnBurstParticles(ServerLevel level, double x, double y, double z) {
        level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 8, 0.2, 0.2, 0.2, 0.02);
        level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 4, 0.2, 0.2, 0.2, 0.01);
    }

    @Override
    protected void spawnParticles(ServerPlayer player, float dashLength) {
        int count = this.getTrailParticleCount();
        for (int i = 0; i < count; ++i) {
            int delay = i;
            ArsAffinity.LOGGER.info("FIRE DASH: scheduled particle tick={} delay={}t", (Object)i, (Object)delay);
            this.scheduleTask(player, delay, () -> {
                Level patt0$temp = player.level();
                if (!(patt0$temp instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                double px = player.getX();
                double py = player.getY();
                double pz = player.getZ();
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, px, py, pz, 2, 0.02, 0.02, 0.02, 0.02);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, px, py, pz, 1, 0.02, 0.02, 0.02, 0.01);
                BlockPos feet = BlockPos.containing((double)Mth.floor((double)px), (double)Mth.floor((double)(py - 0.1)), (double)Mth.floor((double)pz));
                this.placeMagicFireIfAir(serverLevel, feet);
            });
        }
    }

    @Override
    protected void playSounds(ServerPlayer player) {
        Vec3 pos = player.position();
        player.level().playSound(null, pos.x, pos.y, pos.z, (SoundEvent)ModSounds.DASH.get(), SoundSource.PLAYERS, 0.7f, 0.9f);
        for (int i = 0; i < 12; ++i) {
            int delay = i;
            ArsAffinity.LOGGER.info("FIRE DASH: schedule foot fire tick={} delay={}t", (Object)i, (Object)delay);
            this.scheduleTask(player, delay, () -> {
                Level patt0$temp = player.level();
                if (!(patt0$temp instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                BlockPos feet = BlockPos.containing((double)Mth.floor((double)player.getX()), (double)Mth.floor((double)(player.getY() - 0.1)), (double)Mth.floor((double)player.getZ()));
                ArsAffinity.LOGGER.info("FIRE DASH: attempt place fire at {} {} {}", (Object)feet.getX(), (Object)feet.getY(), (Object)feet.getZ());
                this.placeMagicFireIfAir(serverLevel, feet);
            });
        }
    }

    private void placeMagicFireIfAir(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        ArsAffinity.LOGGER.info("FIRE DASH: block at {} {} {} is {}", (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ(), (Object)state);
        if (state.isAir()) {
            boolean placed = level.setBlock(pos, ((MagicFire)BlockRegistry.MAGIC_FIRE.get()).defaultBlockState(), 3);
            ArsAffinity.LOGGER.info("FIRE DASH: setBlock result={} at {} {} {}", (Object)placed, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
            if (!placed) {
                level.setBlockAndUpdate(pos, ((MagicFire)BlockRegistry.MAGIC_FIRE.get()).defaultBlockState());
                ArsAffinity.LOGGER.info("FIRE DASH: fallback setBlockAndUpdate at {} {} {}", (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
            }
            return;
        }
        BlockPos above = pos.above();
        BlockState stateAbove = level.getBlockState(above);
        ArsAffinity.LOGGER.info("FIRE DASH: block above at {} {} {} is {}", (Object)above.getX(), (Object)above.getY(), (Object)above.getZ(), (Object)stateAbove);
        if (stateAbove.isAir()) {
            boolean placedAbove = level.setBlock(above, ((MagicFire)BlockRegistry.MAGIC_FIRE.get()).defaultBlockState(), 3);
            ArsAffinity.LOGGER.info("FIRE DASH: setBlock result={} at above {} {} {}", (Object)placedAbove, (Object)above.getX(), (Object)above.getY(), (Object)above.getZ());
            if (!placedAbove) {
                level.setBlockAndUpdate(above, ((MagicFire)BlockRegistry.MAGIC_FIRE.get()).defaultBlockState());
                ArsAffinity.LOGGER.info("FIRE DASH: fallback setBlockAndUpdate at above {} {} {}", (Object)above.getX(), (Object)above.getY(), (Object)above.getZ());
            }
        }
    }
}

