/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.alexthw.sauce.registry.ModRegistry;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataProvider;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkAllocation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class SauceLibAttributeEvents {
    private static final Map<AffinityPerkType, Holder<Attribute>> POWER_PERK_TO_ATTRIBUTE = new HashMap<AffinityPerkType, Holder<Attribute>>();
    private static final Map<AffinityPerkType, Holder<Attribute>> RESISTANCE_PERK_TO_ATTRIBUTE = new HashMap<AffinityPerkType, Holder<Attribute>>();
    private static final ResourceLocation WATER_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"water_power_perk");
    private static final ResourceLocation WATER_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"water_resistance_perk");
    private static final ResourceLocation FIRE_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"fire_power_perk");
    private static final ResourceLocation FIRE_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"fire_resistance_perk");
    private static final ResourceLocation AIR_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"air_power_perk");
    private static final ResourceLocation AIR_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"air_resistance_perk");
    private static final ResourceLocation EARTH_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"earth_power_perk");
    private static final ResourceLocation EARTH_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"earth_resistance_perk");
    private static final ResourceLocation SUMMON_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"summon_power_perk");
    private static final ResourceLocation CONJURATION_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"conjuration_resistance_perk");
    private static final ResourceLocation ABJURATION_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"abjuration_power_perk");
    private static final ResourceLocation ABJURATION_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"abjuration_resistance_perk");
    private static final ResourceLocation MANIPULATION_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"manipulation_power_perk");
    private static final ResourceLocation MANIPULATION_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"manipulation_resistance_perk");
    private static final ResourceLocation NECROMANCY_POWER_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"necromancy_power_perk");
    private static final ResourceLocation NECROMANCY_RESISTANCE_ID = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"necromancy_resistance_perk");

    private static ResourceLocation getIdForPerk(AffinityPerkType perkType) {
        return switch (perkType) {
            case AffinityPerkType.PASSIVE_WATER_POWER -> WATER_POWER_ID;
            case AffinityPerkType.PASSIVE_WATER_RESISTANCE -> WATER_RESISTANCE_ID;
            case AffinityPerkType.PASSIVE_FIRE_POWER -> FIRE_POWER_ID;
            case AffinityPerkType.PASSIVE_FIRE_RESISTANCE -> FIRE_RESISTANCE_ID;
            case AffinityPerkType.PASSIVE_AIR_POWER -> AIR_POWER_ID;
            case AffinityPerkType.PASSIVE_AIR_RESISTANCE -> AIR_RESISTANCE_ID;
            case AffinityPerkType.PASSIVE_EARTH_POWER -> EARTH_POWER_ID;
            case AffinityPerkType.PASSIVE_EARTH_RESISTANCE -> EARTH_RESISTANCE_ID;
            case AffinityPerkType.PASSIVE_SUMMONING_POWER -> SUMMON_POWER_ID;
            case AffinityPerkType.PASSIVE_CONJURATION_RESISTANCE -> CONJURATION_RESISTANCE_ID;
            case AffinityPerkType.PASSIVE_ABJURATION_POWER -> ABJURATION_POWER_ID;
            case AffinityPerkType.PASSIVE_ABJURATION_RESISTANCE -> ABJURATION_RESISTANCE_ID;
            case AffinityPerkType.PASSIVE_MANIPULATION_POWER -> MANIPULATION_POWER_ID;
            case AffinityPerkType.PASSIVE_MANIPULATION_RESISTANCE -> MANIPULATION_RESISTANCE_ID;
            case AffinityPerkType.PASSIVE_ANIMA_POWER -> NECROMANCY_POWER_ID;
            case AffinityPerkType.PASSIVE_ANIMA_RESISTANCE -> NECROMANCY_RESISTANCE_ID;
            default -> null;
        };
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SauceLibAttributeEvents.updatePlayerAttributes(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide() && player.tickCount % 20 == 0) {
            SauceLibAttributeEvents.updatePlayerAttributes(player);
        }
    }

    private static void updatePlayerAttributes(Player player) {
        PlayerAffinityData affinityData = PlayerAffinityDataProvider.getPlayerAffinityData(player);
        if (affinityData == null) {
            return;
        }
        HashMap<AffinityPerkType, Integer> perkAmounts = new HashMap<AffinityPerkType, Integer>();
        for (PerkAllocation perkAllocation : affinityData.getAllAllocatedPerks()) {
            AffinityPerkType type = perkAllocation.getPerkType();
            int amount = (int)perkAllocation.getNode().getAmount();
            int currentAmount = perkAmounts.getOrDefault((Object)type, 0);
            perkAmounts.put(type, currentAmount + amount);
        }
        for (Map.Entry entry : POWER_PERK_TO_ATTRIBUTE.entrySet()) {
            SauceLibAttributeEvents.applyAttributeModifier(player, (AffinityPerkType)((Object)entry.getKey()), (Holder<Attribute>)((Holder)entry.getValue()), perkAmounts.getOrDefault(entry.getKey(), 0));
        }
        for (Map.Entry entry : RESISTANCE_PERK_TO_ATTRIBUTE.entrySet()) {
            SauceLibAttributeEvents.applyAttributeModifier(player, (AffinityPerkType)((Object)entry.getKey()), (Holder<Attribute>)((Holder)entry.getValue()), perkAmounts.getOrDefault(entry.getKey(), 0));
        }
    }

    private static void applyAttributeModifier(Player player, AffinityPerkType perkType, Holder<Attribute> attribute, int amount) {
        AttributeInstance instance = player.getAttribute(attribute);
        if (instance == null) {
            return;
        }
        ResourceLocation modifierId = SauceLibAttributeEvents.getIdForPerk(perkType);
        if (modifierId == null) {
            return;
        }
        AttributeModifier existingModifier = instance.getModifier(modifierId);
        if (amount > 0) {
            if (existingModifier == null || existingModifier.amount() != (double)amount) {
                if (existingModifier != null) {
                    instance.removeModifier(existingModifier);
                }
                AttributeModifier newModifier = new AttributeModifier(modifierId, (double)amount, AttributeModifier.Operation.ADD_VALUE);
                instance.addTransientModifier(newModifier);
            }
        } else if (existingModifier != null) {
            instance.removeModifier(existingModifier);
        }
    }

    static {
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_WATER_POWER, (Holder<Attribute>)ModRegistry.WATER_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_WATER_RESISTANCE, (Holder<Attribute>)ModRegistry.WATER_RESISTANCE);
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_FIRE_POWER, (Holder<Attribute>)ModRegistry.FIRE_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_FIRE_RESISTANCE, (Holder<Attribute>)ModRegistry.FIRE_RESISTANCE);
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_AIR_POWER, (Holder<Attribute>)ModRegistry.AIR_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_AIR_RESISTANCE, (Holder<Attribute>)ModRegistry.AIR_RESISTANCE);
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_EARTH_POWER, (Holder<Attribute>)ModRegistry.EARTH_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_EARTH_RESISTANCE, (Holder<Attribute>)ModRegistry.EARTH_RESISTANCE);
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_SUMMONING_POWER, (Holder<Attribute>)ModRegistry.SUMMON_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_CONJURATION_RESISTANCE, (Holder<Attribute>)ModRegistry.CONJURATION_RESISTANCE);
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_ABJURATION_POWER, (Holder<Attribute>)ModRegistry.ABJURATION_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_ABJURATION_RESISTANCE, (Holder<Attribute>)ModRegistry.ABJURATION_RESISTANCE);
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_MANIPULATION_POWER, (Holder<Attribute>)ModRegistry.MANIPULATION_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_MANIPULATION_RESISTANCE, (Holder<Attribute>)ModRegistry.MANIPULATION_RESISTANCE);
        POWER_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_ANIMA_POWER, (Holder<Attribute>)ModRegistry.NECROMANCY_POWER);
        RESISTANCE_PERK_TO_ATTRIBUTE.put(AffinityPerkType.PASSIVE_ANIMA_RESISTANCE, (Holder<Attribute>)ModRegistry.NECROMANCY_RESISTANCE);
    }
}

