/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.perk.AffinityPerkManager;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkAllocation;
import com.github.ars_affinity.perk.PerkData;
import com.github.ars_affinity.perk.PerkNode;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;

public class AffinityPerkHelper {
    private static boolean hasActivePerk(PlayerAffinityData data, AffinityPerkType perkType) {
        return data.getAllAllocatedPerks().stream().anyMatch(allocation -> allocation.getPerkType() == perkType);
    }

    public static boolean hasActivePerk(Player player, AffinityPerkType perkType) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data != null) {
            return AffinityPerkHelper.hasActivePerk(data, perkType);
        }
        return false;
    }

    public static AffinityPerk getAllocatedPerk(PlayerAffinityData data, AffinityPerkType perkType) {
        return data.getAllAllocatedPerks().stream().filter(allocation -> allocation.getPerkType() == perkType).max((a1, a2) -> Integer.compare(a1.getTier(), a2.getTier())).map(allocation -> AffinityPerkManager.getHighestLevelPerk(allocation.getNode().getSchool(), perkType)).orElse(null);
    }

    public static AffinityPerk getAllocatedPerk(Player player, AffinityPerkType perkType) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data != null) {
            return AffinityPerkHelper.getAllocatedPerk(data, perkType);
        }
        return null;
    }

    public static PerkData getActivePerkData(PlayerAffinityData data, AffinityPerkType perkType) {
        return data.getAllAllocatedPerks().stream().filter(allocation -> allocation.getPerkType() == perkType).findFirst().map(allocation -> {
            PerkNode node = allocation.getNode();
            AffinityPerk perk = AffinityPerkHelper.createAffinityPerkFromNode(node);
            return new PerkData(perk, allocation.getSchool(), allocation.getTier());
        }).orElse(null);
    }

    public static SpellSchool getPerkSourceSchool(PlayerAffinityData data, AffinityPerkType perkType) {
        return data.getAllAllocatedPerks().stream().filter(allocation -> allocation.getPerkType() == perkType).findFirst().map(allocation -> allocation.getSchool()).orElse(null);
    }

    public static int getPerkSourceTier(PlayerAffinityData data, AffinityPerkType perkType) {
        return data.getAllAllocatedPerks().stream().filter(allocation -> allocation.getPerkType() == perkType).findFirst().map(allocation -> allocation.getTier()).orElse(0);
    }

    public static void applyActivePerk(PlayerAffinityData data, AffinityPerkType perkType, Consumer<AffinityPerk> perkConsumer) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(data, perkType);
        if (perk != null) {
            perkConsumer.accept(perk);
        }
    }

    public static void applyActivePerk(Player player, AffinityPerkType perkType, Consumer<AffinityPerk> perkConsumer) {
        AffinityPerk perk;
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data != null && (perk = AffinityPerkHelper.getAllocatedPerk(data, perkType)) != null) {
            perkConsumer.accept(perk);
        }
    }

    public static <T extends AffinityPerk> void applyActivePerk(Player player, AffinityPerkType perkType, Class<T> perkClass, Consumer<T> perkConsumer) {
        AffinityPerk perk;
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data != null && (perk = AffinityPerkHelper.getAllocatedPerk(data, perkType)) != null && perkClass.isInstance(perk)) {
            perkConsumer.accept((AffinityPerk)perkClass.cast(perk));
        }
    }

    public static void applyActivePerkData(PlayerAffinityData data, AffinityPerkType perkType, Consumer<PerkData> perkDataConsumer) {
        PerkData perkData = AffinityPerkHelper.getActivePerkData(data, perkType);
        if (perkData != null) {
            perkDataConsumer.accept(perkData);
        }
    }

    public static Set<PerkAllocation> getAllActivePerkAllocations(PlayerAffinityData data) {
        return data.getAllAllocatedPerks();
    }

    public static float getPerkAmount(Player player, AffinityPerkType perkType) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(player, perkType);
        if (perk instanceof AffinityPerk.AmountBasedPerk) {
            AffinityPerk.AmountBasedPerk amountPerk = (AffinityPerk.AmountBasedPerk)perk;
            return amountPerk.amount;
        }
        if (perk instanceof AffinityPerk.DurationBasedPerk) {
            AffinityPerk.DurationBasedPerk durationPerk = (AffinityPerk.DurationBasedPerk)perk;
            return durationPerk.amount;
        }
        if (perk instanceof AffinityPerk.GhostStepPerk) {
            AffinityPerk.GhostStepPerk ghostStepPerk = (AffinityPerk.GhostStepPerk)perk;
            return ghostStepPerk.amount;
        }
        return 0.0f;
    }

    public static int getPerkTime(Player player, AffinityPerkType perkType) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(player, perkType);
        if (perk instanceof AffinityPerk.DurationBasedPerk) {
            AffinityPerk.DurationBasedPerk durationPerk = (AffinityPerk.DurationBasedPerk)perk;
            return durationPerk.time;
        }
        if (perk instanceof AffinityPerk.GhostStepPerk) {
            AffinityPerk.GhostStepPerk ghostStepPerk = (AffinityPerk.GhostStepPerk)perk;
            return ghostStepPerk.time;
        }
        return 0;
    }

    public static int getPerkCooldown(Player player, AffinityPerkType perkType) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(player, perkType);
        if (perk instanceof AffinityPerk.GhostStepPerk) {
            AffinityPerk.GhostStepPerk ghostStepPerk = (AffinityPerk.GhostStepPerk)perk;
            return ghostStepPerk.cooldown;
        }
        return 0;
    }

    public static float getPerkHealth(Player player, AffinityPerkType perkType) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(player, perkType);
        if (perk instanceof AffinityPerk.LichFeastPerk) {
            AffinityPerk.LichFeastPerk lichPerk = (AffinityPerk.LichFeastPerk)perk;
            return lichPerk.health;
        }
        return 0.0f;
    }

    public static float getPerkHunger(Player player, AffinityPerkType perkType) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(player, perkType);
        if (perk instanceof AffinityPerk.LichFeastPerk) {
            AffinityPerk.LichFeastPerk lichPerk = (AffinityPerk.LichFeastPerk)perk;
            return lichPerk.hunger;
        }
        return 0.0f;
    }

    public static float getPerkChance(Player player, AffinityPerkType perkType) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(player, perkType);
        if (perk instanceof AffinityPerk.UnstableSummoningPerk) {
            AffinityPerk.UnstableSummoningPerk unstablePerk = (AffinityPerk.UnstableSummoningPerk)perk;
            return unstablePerk.chance;
        }
        return 0.0f;
    }

    public static List<String> getPerkEntities(Player player, AffinityPerkType perkType) {
        AffinityPerk perk = AffinityPerkHelper.getAllocatedPerk(player, perkType);
        if (perk instanceof AffinityPerk.UnstableSummoningPerk) {
            AffinityPerk.UnstableSummoningPerk unstablePerk = (AffinityPerk.UnstableSummoningPerk)perk;
            return unstablePerk.entities;
        }
        return Collections.emptyList();
    }

    public static int getPerkTier(Player player, AffinityPerkType perkType) {
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data != null) {
            return data.getAllAllocatedPerks().stream().filter(allocation -> allocation.getPerkType() == perkType).mapToInt(PerkAllocation::getTier).max().orElse(0);
        }
        return 0;
    }

    public static AffinityPerk createAffinityPerkFromNode(PerkNode node) {
        AffinityPerkType perkType = node.getPerkType();
        boolean isBuff = true;
        switch (perkType) {
            case PASSIVE_FIRE_THORNS: 
            case PASSIVE_MANA_TAP: 
            case PASSIVE_HEALING_AMPLIFICATION: 
            case PASSIVE_SOULSPIKE: 
            case PASSIVE_SUMMONING_POWER: 
            case PASSIVE_ABJURATION_POWER: 
            case PASSIVE_AIR_POWER: 
            case PASSIVE_EARTH_POWER: 
            case PASSIVE_FIRE_POWER: 
            case PASSIVE_MANIPULATION_POWER: 
            case PASSIVE_ANIMA_POWER: 
            case PASSIVE_WATER_POWER: 
            case PASSIVE_ABJURATION_RESISTANCE: 
            case PASSIVE_CONJURATION_RESISTANCE: 
            case PASSIVE_AIR_RESISTANCE: 
            case PASSIVE_EARTH_RESISTANCE: 
            case PASSIVE_FIRE_RESISTANCE: 
            case PASSIVE_MANIPULATION_RESISTANCE: 
            case PASSIVE_ANIMA_RESISTANCE: 
            case PASSIVE_WATER_RESISTANCE: 
            case PASSIVE_COLD_WALKER: {
                return new AffinityPerk.AmountBasedPerk(perkType, node.getAmount(), isBuff);
            }
            case PASSIVE_SUMMON_HEALTH: 
            case PASSIVE_SUMMON_DEFENSE: 
            case PASSIVE_STONE_SKIN: 
            case PASSIVE_DEFLECTION: 
            case PASSIVE_HYDRATION: {
                return new AffinityPerk.DurationBasedPerk(perkType, node.getAmount(), node.getTime(), isBuff);
            }
            case PASSIVE_LICH_FEAST: {
                float healthRestore = node.getAmount() * 0.1f;
                float hungerRestore = node.getAmount() * 0.05f;
                return new AffinityPerk.LichFeastPerk(perkType, healthRestore, hungerRestore, isBuff);
            }
            case ACTIVE_ICE_BLAST: {
                return new AffinityPerk.ActiveAbilityPerk(perkType, node.getManaCost(), node.getCooldown(), node.getDamage(), node.getFreezeTime(), node.getRadius(), isBuff);
            }
            case ACTIVE_GROUND_SLAM: 
            case ACTIVE_SWAP_ABILITY: 
            case ACTIVE_SANCTUARY: 
            case ACTIVE_CURSE_FIELD: {
                return new AffinityPerk.ActiveAbilityPerk(perkType, node.getManaCost(), node.getCooldown(), 0.0f, 0, 0.0f, isBuff);
            }
            case ACTIVE_AIR_DASH: 
            case ACTIVE_FIRE_DASH: 
            case ACTIVE_GHOST_STEP: {
                return new AffinityPerk.ActiveAbilityPerk(perkType, node.getManaCost(), node.getCooldown(), 0.0f, 0, 0.0f, node.getDashLength(), node.getDashDuration(), isBuff);
            }
            case PASSIVE_GHOST_STEP: {
                return new AffinityPerk.GhostStepPerk(perkType, node.getAmount(), node.getTime(), node.getCooldown(), isBuff);
            }
            case PASSIVE_ROTTING_GUISE: {
                return new AffinityPerk.SimplePerk(perkType, isBuff);
            }
        }
        ArsAffinity.LOGGER.warn("Unknown perk type: {}, using default AmountBasedPerk", (Object)perkType);
        return new AffinityPerk.AmountBasedPerk(perkType, node.getAmount(), isBuff);
    }
}

