/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.perk.ActiveAbilityHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.GlyphPrerequisiteHelper;
import com.github.ars_affinity.perk.PerkNode;
import com.github.ars_affinity.perk.PerkTreeManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class PerkPrerequisiteChecker {
    public static PrerequisiteResult checkPrerequisites(Player player, PerkNode node) {
        AffinityPerkType currentActiveAbility;
        ArrayList<String> reasons = new ArrayList<String>();
        PlayerAffinityData data = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        if (data == null) {
            reasons.add("Player data not available");
            return new PrerequisiteResult(false, reasons);
        }
        if (data.isPerkAllocated(node.getId())) {
            reasons.add("Perk already allocated");
            return new PrerequisiteResult(false, reasons);
        }
        int availablePoints = data.getAvailablePoints(node.getSchool());
        if (availablePoints < node.getPointCost()) {
            reasons.add("No points available");
        }
        for (String prereq : node.getPrerequisites()) {
            if (data.isPerkAllocated(prereq)) continue;
            PerkNode prereqNode = PerkTreeManager.getNode(prereq);
            if (prereqNode != null) {
                reasons.add("Previous perks not unlocked");
                break;
            }
            reasons.add("Previous perks not unlocked");
            break;
        }
        if (node.hasPrerequisiteGlyph() && !GlyphPrerequisiteHelper.hasUnlockedGlyph(player, node.getPrerequisiteGlyph())) {
            String glyphName = GlyphPrerequisiteHelper.getGlyphDisplayName(node.getPrerequisiteGlyph());
            reasons.add("Glyph '" + glyphName + "' not unlocked");
        }
        if (ActiveAbilityHelper.isActiveAbility(node.getPerkType()) && (currentActiveAbility = data.getCurrentActiveAbilityType()) != null && currentActiveAbility != node.getPerkType()) {
            reasons.add("Existing active ability already allocated");
        }
        boolean canAllocate = reasons.isEmpty();
        return new PrerequisiteResult(canAllocate, reasons);
    }

    public static MutableComponent getPrerequisiteTooltip(Player player, PerkNode node) {
        PrerequisiteResult result = PerkPrerequisiteChecker.checkPrerequisites(player, node);
        if (result.canAllocate()) {
            return Component.empty();
        }
        MutableComponent tooltip = Component.translatable((String)"ars_affinity.tooltip.prerequisites_not_met");
        if (result.hasReasons()) {
            tooltip.append("\n");
            for (String reason : result.getReasons()) {
                tooltip.append("\n").append((Component)Component.literal((String)("\u2022 " + reason)));
            }
        }
        return tooltip;
    }

    public static class PrerequisiteResult {
        private final boolean canAllocate;
        private final List<String> reasons;

        public PrerequisiteResult(boolean canAllocate, List<String> reasons) {
            this.canAllocate = canAllocate;
            this.reasons = new ArrayList<String>(reasons);
        }

        public boolean canAllocate() {
            return this.canAllocate;
        }

        public List<String> getReasons() {
            return new ArrayList<String>(this.reasons);
        }

        public boolean hasReasons() {
            return !this.reasons.isEmpty();
        }
    }
}

