/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.school;

import com.github.ars_affinity.config.ArsAffinityConfig;
import com.github.ars_affinity.util.SchoolColors;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SchoolRelationshipHelper {
    private static final Map<SpellSchool, SpellSchool> OPPOSITE_SCHOOLS = new HashMap<SpellSchool, SpellSchool>();
    public static final SpellSchool[] ALL_SCHOOLS;
    private static boolean configValidated;

    private SchoolRelationshipHelper() {
    }

    public static SpellSchool getOppositeSchool(SpellSchool school) {
        return OPPOSITE_SCHOOLS.get(school);
    }

    public static boolean areOpposites(SpellSchool school1, SpellSchool school2) {
        if (school1 == null || school2 == null) {
            return false;
        }
        return school1.equals(SchoolRelationshipHelper.getOppositeSchool(school2));
    }

    public static Map<SpellSchool, Float> calculateAffinityChanges(SpellSchool castSchool, float mana) {
        HashMap<SpellSchool, Float> changes = new HashMap<SpellSchool, Float>();
        float multiplier = ((Double)ArsAffinityConfig.AFFINITY_GAIN_MULTIPLIER.get()).floatValue();
        float baseAmount = mana * multiplier / 100.0f;
        changes.put(castSchool, Float.valueOf(baseAmount));
        SpellSchool oppositeSchool = SchoolRelationshipHelper.getOppositeSchool(castSchool);
        float opposingPenaltyPercentage = ((Double)ArsAffinityConfig.OPPOSING_SCHOOL_PENALTY_PERCENTAGE.get()).floatValue();
        int otherSchoolsCount = 0;
        for (SpellSchool school : ALL_SCHOOLS) {
            if (school == castSchool || school == oppositeSchool) continue;
            ++otherSchoolsCount;
        }
        for (SpellSchool school : ALL_SCHOOLS) {
            float penalty;
            if (school == castSchool) continue;
            if (school == oppositeSchool) {
                penalty = -baseAmount * opposingPenaltyPercentage;
            } else {
                float remainingPenaltyPercentage = 1.0f - opposingPenaltyPercentage;
                penalty = -(baseAmount * remainingPenaltyPercentage) / (float)otherSchoolsCount;
            }
            changes.put(school, Float.valueOf(penalty));
        }
        return changes;
    }

    public static Map<SpellSchool, Float> applyAffinityChanges(Map<SpellSchool, Float> currentAffinities, Map<SpellSchool, Float> changes) {
        HashMap<SpellSchool, Float> newAffinities = new HashMap<SpellSchool, Float>();
        for (SpellSchool school : ALL_SCHOOLS) {
            float currentAffinity = currentAffinities.getOrDefault(school, Float.valueOf(0.0f)).floatValue();
            float change = changes.getOrDefault(school, Float.valueOf(0.0f)).floatValue();
            float newAffinity = Math.max(0.0f, Math.min(1.0f, currentAffinity + change));
            newAffinities.put(school, Float.valueOf(newAffinity));
        }
        float total = 0.0f;
        Iterator<Object> iterator = newAffinities.values().iterator();
        while (iterator.hasNext()) {
            float value = ((Float)iterator.next()).floatValue();
            total += value;
        }
        if (total > 1.0f) {
            for (SpellSchool school : newAffinities.keySet()) {
                float value = ((Float)newAffinities.get(school)).floatValue();
                newAffinities.put(school, Float.valueOf(value / total));
            }
        }
        return newAffinities;
    }

    public static int calculateTierFromAffinity(float affinity) {
        if (!configValidated) {
            ArsAffinityConfig.validateTierThresholds();
            configValidated = true;
        }
        float percentage = affinity * 100.0f;
        double tier3Threshold = (Double)ArsAffinityConfig.TIER_3_THRESHOLD_PERCENTAGE.get();
        double tier2Threshold = (Double)ArsAffinityConfig.TIER_2_THRESHOLD_PERCENTAGE.get();
        double tier1Threshold = (Double)ArsAffinityConfig.TIER_1_THRESHOLD_PERCENTAGE.get();
        if ((double)percentage >= tier3Threshold) {
            return 3;
        }
        if ((double)percentage >= tier2Threshold) {
            return 2;
        }
        if ((double)percentage >= tier1Threshold) {
            return 1;
        }
        return 0;
    }

    public static int getColorForSchool(SpellSchool school) {
        return SchoolColors.getHexColor(school);
    }

    static {
        OPPOSITE_SCHOOLS.put(SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER);
        OPPOSITE_SCHOOLS.put(SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_FIRE);
        OPPOSITE_SCHOOLS.put(SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_AIR);
        OPPOSITE_SCHOOLS.put(SpellSchools.ELEMENTAL_AIR, SpellSchools.ELEMENTAL_EARTH);
        OPPOSITE_SCHOOLS.put(SpellSchools.ABJURATION, SpellSchools.NECROMANCY);
        OPPOSITE_SCHOOLS.put(SpellSchools.NECROMANCY, SpellSchools.ABJURATION);
        OPPOSITE_SCHOOLS.put(SpellSchools.CONJURATION, SpellSchools.MANIPULATION);
        OPPOSITE_SCHOOLS.put(SpellSchools.MANIPULATION, SpellSchools.CONJURATION);
        ALL_SCHOOLS = new SpellSchool[]{SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_AIR, SpellSchools.ABJURATION, SpellSchools.NECROMANCY, SpellSchools.CONJURATION, SpellSchools.MANIPULATION};
        configValidated = false;
    }
}

