/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.entity.spells.EntityMagnetSpell;
import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.CompatUtils;
import com.alexthw.sauce.util.EntityCarryMEI;
import com.alexthw.sauce.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectEvaporate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGrow;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import java.util.List;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;

@EventBusSubscriber(modid="ars_elemental")
public class GlyphEvents {
    @SubscribeEvent
    public static void empowerGlyphs(EffectResolveEvent.Pre event) {
        if (!((Boolean)ConfigHandler.COMMON.EnableGlyphEmpowering.get()).booleanValue()) {
            return;
        }
        HitResult hitResult = event.rayTraceResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            GlyphEvents.empowerResolveOnBlocks(event, blockHitResult, event.resolver);
        } else {
            hitResult = event.rayTraceResult;
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                GlyphEvents.empowerResolveOnEntities(event, entityHitResult, event.resolver);
            }
        }
    }

    public static void empowerResolveOnEntities(EffectResolveEvent.Pre event, EntityHitResult entityHitResult, SpellResolver resolver) {
        MobEffectInstance mobEffectInstance;
        LivingEntity living;
        block18: {
            block17: {
                Entity entity = entityHitResult.getEntity();
                if (!(entity instanceof LivingEntity)) break block17;
                living = (LivingEntity)entity;
                if (event.world instanceof ServerLevel) break block18;
            }
            return;
        }
        boolean hasFire = CompatUtils.fireCheck(resolver);
        boolean hasWater = CompatUtils.waterCheck(resolver);
        boolean hasEarth = CompatUtils.earthCheck(resolver);
        boolean hasAir = CompatUtils.airCheck(resolver);
        if (event.resolveEffect == EffectCut.INSTANCE && living.hasEffect(ModPotions.LIFE_LINK) && (mobEffectInstance = living.getEffect(ModPotions.LIFE_LINK)) instanceof EntityCarryMEI) {
            EntityCarryMEI effect = (EntityCarryMEI)mobEffectInstance;
            if (effect.getOwner() != null) {
                effect.getOwner().removeEffect(ModPotions.LIFE_LINK);
            }
            if (effect.getTarget() != null) {
                effect.getTarget().removeEffect(ModPotions.LIFE_LINK);
            }
        }
        if (event.resolveEffect == EffectIgnite.INSTANCE && hasFire) {
            living.addEffect(new MobEffectInstance(ModPotions.MAGIC_FIRE, 200), (Entity)living);
        }
        if (event.resolveEffect == EffectLaunch.INSTANCE && event.spellStats.getDurationMultiplier() != 0.0 && hasAir) {
            ServerPlayer serverPlayer;
            living.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 50 * (1 + (int)event.spellStats.getDurationMultiplier()), (int)event.spellStats.getAmpMultiplier() / 2));
            mobEffectInstance = event.shooter;
            if (mobEffectInstance instanceof ServerPlayer && !((serverPlayer = (ServerPlayer)mobEffectInstance) instanceof FakePlayer)) {
                ((PlayerTrigger)ModAdvTriggers.LEVITATE.get()).trigger(serverPlayer);
            }
        }
        if (event.resolveEffect == EffectFreeze.INSTANCE && event.shooter != living && hasWater) {
            Skeleton skeleton;
            if (living instanceof Skeleton && (skeleton = (Skeleton)living).getType() == EntityType.SKELETON) {
                skeleton.setFreezeConverting(true);
            }
            living.setIsInPowderSnow(true);
            int newFrozenTicks = living.getTicksFrozen() + (int)(60.0 * event.spellStats.getAmpMultiplier());
            living.setTicksFrozen(newFrozenTicks);
            if (living.isFullyFrozen() && living.canFreeze()) {
                living.forceAddEffect(new MobEffectInstance(ModPotions.FROZEN, 60, 0, false, false, false), (Entity)living);
            }
        }
        if (event.resolveEffect == EffectGrow.INSTANCE && living.getType().is(EntityTypeTags.UNDEAD) && hasEarth && event.shooter instanceof Player) {
            ((IDamageEffect)event.resolveEffect).attemptDamage(event.world, event.shooter, event.spellStats, event.context, event.resolver, (Entity)living, event.world.damageSources().magic(), (float)(3.0 + 2.0 * event.spellStats.getAmpMultiplier()));
            if (living.isDeadOrDying() && event.world.getRandom().nextInt(100) < 20) {
                BlockPos feet = living.getOnPos();
                BlockState underfoot = living.level().getBlockState(feet);
                if ((underfoot.getBlock() == Blocks.MOSS_BLOCK || underfoot.is(BlockTags.DIRT) || underfoot.is(BlockTags.LEAVES)) && event.world.getBlockState(feet.above()).isAir()) {
                    ServerPlayer serverPlayer;
                    living.level().setBlockAndUpdate(feet.above(), ((Block)ModItems.GROUND_BLOSSOM.get()).defaultBlockState());
                    LivingEntity livingEntity = event.shooter;
                    if (livingEntity instanceof ServerPlayer && !((serverPlayer = (ServerPlayer)livingEntity) instanceof FakePlayer)) {
                        ((PlayerTrigger)ModAdvTriggers.BLOSSOM.get()).trigger(serverPlayer);
                    }
                }
            }
        }
        if (event.resolveEffect == EffectGravity.INSTANCE && event.spellStats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE) && hasEarth) {
            EntityMagnetSpell magnet = EntityMagnetSpell.createMagnet(event.world, event.shooter, event.spellStats, event.resolver, event.rayTraceResult.getLocation());
            magnet.setTracked(entityHitResult.getEntity());
            event.world.addFreshEntity((Entity)magnet);
            event.setCanceled(true);
        }
    }

    public static void empowerResolveOnBlocks(EffectResolveEvent.Pre event, BlockHitResult blockHitResult, SpellResolver resolver) {
        LivingEntity livingEntity;
        boolean hasFire = CompatUtils.fireCheck(resolver);
        boolean hasWater = CompatUtils.waterCheck(resolver);
        boolean hasEarth = CompatUtils.earthCheck(resolver);
        if (event.resolveEffect == EffectConjureWater.INSTANCE && hasWater && GlyphEffectUtil.hasFollowingEffect((SpellContext)event.context, (AbstractEffect)EffectFreeze.INSTANCE)) {
            GlyphEffectUtil.placeBlocks((BlockHitResult)blockHitResult, (Level)event.world, (LivingEntity)event.shooter, (SpellStats)event.spellStats, (SpellContext)event.context, (SpellResolver)new SpellResolver(event.context), (BlockState)Blocks.ICE.defaultBlockState());
            event.setCanceled(true);
        }
        if (event.resolveEffect == EffectGravity.INSTANCE && event.spellStats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE) && hasEarth) {
            EntityMagnetSpell magnet = EntityMagnetSpell.createMagnet(event.world, event.shooter, event.spellStats, event.resolver, event.rayTraceResult.getLocation());
            event.world.addFreshEntity((Entity)magnet);
            event.setCanceled(true);
        }
        if (event.resolveEffect == EffectIgnite.INSTANCE && (livingEntity = event.shooter) instanceof Player) {
            Player player = (Player)livingEntity;
            int pierceBuff = event.spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
            List posList = SpellUtil.calcAOEBlocks((LivingEntity)event.shooter, (BlockPos)blockHitResult.getBlockPos(), (BlockHitResult)blockHitResult, (double)event.spellStats.getAoeMultiplier(), (int)pierceBuff);
            boolean flag = hasFire && GlyphEffectUtil.hasFollowingEffect((SpellContext)event.context, (AbstractEffect)EffectEvaporate.INSTANCE);
            for (BlockPos pos1 : posList) {
                BlockState state = event.world.getBlockState(pos1);
                if (!state.is(BlockTags.ICE) && !state.is(BlockTags.SNOW)) continue;
                if (flag) {
                    event.world.setBlock(pos1, Blocks.AIR.defaultBlockState(), 3);
                } else {
                    state.getBlock().playerDestroy(event.world, player, pos1, state, null, ItemStack.EMPTY);
                }
                event.setCanceled(true);
            }
        }
    }
}

