/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.search;

import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.LowerCaseFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.ars_nouveau.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.ars_nouveau.analysis.standard.StandardTokenizer;

public class NGramAnalyzer
extends Analyzer {
    private final int minGram;
    private final int maxGram;

    public NGramAnalyzer(int minGram, int maxGram) {
        this.minGram = minGram;
        this.maxGram = maxGram;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer tokenizer = new StandardTokenizer();
        TokenFilter tokenStream = new EnglishPossessiveFilter(tokenizer);
        tokenStream = new LowerCaseFilter(tokenStream);
        tokenStream = new NGramTokenFilter(tokenStream, this.minGram, this.maxGram, false);
        return new Analyzer.TokenStreamComponents(tokenizer, (TokenStream)tokenStream);
    }
}

