/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ManaUtil {
    static final ResourceLocation MAX_MANA_MODIFIER = ArsNouveau.prefix("max_mana_mod");
    static final ResourceLocation MANA_REGEN_MODIFIER = ArsNouveau.prefix("max_regen_mod");

    public static int getPlayerDiscounts(LivingEntity e, Spell spell, ItemStack casterStack) {
        IManaDiscountEquipment discountItem;
        Item item;
        if (e == null) {
            return 0;
        }
        AtomicInteger discounts = new AtomicInteger();
        IItemHandlerModifiable items = CuriosUtil.getAllWornItems(e);
        if (items != null) {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack item2 = items.getStackInSlot(i);
                item = item2.getItem();
                if (!(item instanceof IManaDiscountEquipment)) continue;
                discountItem = (IManaDiscountEquipment)item;
                discounts.addAndGet(discountItem.getManaDiscount(item2, spell));
            }
        }
        for (ItemStack armor : e.getArmorSlots()) {
            item = armor.getItem();
            if (!(item instanceof IManaDiscountEquipment)) continue;
            discountItem = (IManaDiscountEquipment)item;
            discounts.addAndGet(discountItem.getManaDiscount(armor, spell));
        }
        Item item3 = casterStack.getItem();
        if (item3 instanceof IManaDiscountEquipment) {
            IManaDiscountEquipment discountEquipment = (IManaDiscountEquipment)item3;
            discounts.addAndGet(discountEquipment.getManaDiscount(casterStack, spell));
        }
        return discounts.get();
    }

    public static double getCurrentMana(LivingEntity e) {
        ManaCap mana = CapabilityRegistry.getMana(e);
        if (mana == null) {
            return 0.0;
        }
        return mana.getCurrentMana();
    }

    public static Mana calcMaxMana(Player e) {
        ManaCap mana = CapabilityRegistry.getMana((LivingEntity)e);
        if (mana == null) {
            return new Mana(0, 0.0f);
        }
        double rawMax = 0.0;
        int tier = mana.getBookTier();
        int numGlyphs = mana.getGlyphBonus();
        rawMax += (double)((Integer)ServerConfig.INIT_MAX_MANA.get()).intValue();
        rawMax += (double)(numGlyphs * (Integer)ServerConfig.GLYPH_MAX_BONUS.get());
        rawMax += (double)(tier * (Integer)ServerConfig.TIER_MAX_BONUS.get());
        AttributeInstance manaAttribute = e.getAttribute(PerkAttributes.MAX_MANA);
        if (manaAttribute != null) {
            AttributeModifier manaCache = manaAttribute.getModifier(MAX_MANA_MODIFIER);
            if (manaCache == null || manaCache.amount() != rawMax) {
                if (manaCache != null) {
                    manaAttribute.removeModifier(manaCache);
                }
                manaAttribute.addTransientModifier(new AttributeModifier(MAX_MANA_MODIFIER, rawMax, AttributeModifier.Operation.ADD_VALUE));
            }
            rawMax = manaAttribute.getValue();
        }
        int max = (int)rawMax;
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max);
        NeoForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        float reserve = event.getReserve();
        return new Mana(max, reserve);
    }

    public static int getMaxMana(Player e) {
        return ManaUtil.calcMaxMana(e).getRealMax();
    }

    public static double getManaRegen(Player e) {
        ManaCap mana = CapabilityRegistry.getMana((LivingEntity)e);
        if (mana == null) {
            return 0.0;
        }
        double regen = 0.0;
        int tier = mana.getBookTier();
        double numGlyphs = mana.getGlyphBonus();
        regen += numGlyphs * (Double)ServerConfig.GLYPH_REGEN_BONUS.get();
        regen += (double)(tier * (Integer)ServerConfig.TIER_REGEN_BONUS.get());
        regen += (double)((Integer)ServerConfig.INIT_MANA_REGEN.get()).intValue();
        AttributeInstance manaAttribute = e.getAttribute(PerkAttributes.MANA_REGEN_BONUS);
        if (manaAttribute != null) {
            AttributeModifier manaCache = manaAttribute.getModifier(MANA_REGEN_MODIFIER);
            if (manaCache == null || manaCache.amount() != regen) {
                if (manaCache != null) {
                    manaAttribute.removeModifier(manaCache);
                }
                manaAttribute.addTransientModifier(new AttributeModifier(MANA_REGEN_MODIFIER, regen, AttributeModifier.Operation.ADD_VALUE));
            }
            regen = manaAttribute.getValue();
        }
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen);
        NeoForge.EVENT_BUS.post((Event)event);
        regen = event.getRegen();
        return regen;
    }

    public record Mana(int Max, float Reserve) {
        public int getRealMax() {
            return (int)((double)this.Max * (1.0 - (double)this.Reserve));
        }
    }
}

