/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.documentation;

import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class EntriesScreen
extends BaseDocScreen {
    List<DocEntry> entries;
    List<DocEntryButton> buttons = new ArrayList<DocEntryButton>();
    DocCategory category;

    public EntriesScreen(DocCategory category) {
        this.category = category;
        ArrayList<DocEntry> entries = new ArrayList<DocEntry>(DocumentationRegistry.getEntries(category));
        entries.sort(category.entryComparator());
        this.entries = new ArrayList<DocEntry>(entries);
        if (this.entries.size() > 17) {
            this.maxArrowIndex = 1 + (this.entries.size() - 17) / 18;
        }
    }

    @Override
    public void init() {
        super.init();
        this.initButtons();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.arrowIndex == 0) {
            DocClientUtils.drawHeader(this.category.getTitle(), graphics, this.screenLeft + 19, this.screenTop + 17, 118, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void onArrowIndexChange() {
        super.onArrowIndexChange();
        this.initButtons();
    }

    public void initButtons() {
        for (DocEntryButton button : this.buttons) {
            this.removeWidget((GuiEventListener)button);
        }
        this.buttons.clear();
        int offset = 17;
        if (this.arrowIndex == 0) {
            this.getLeftPageButtons(0, 8);
            this.getRightPageButtons(8, offset);
        } else {
            int offsetIndex = this.arrowIndex * 18 - 1;
            this.getLeftPageButtons(offsetIndex, offsetIndex + 9);
            this.getRightPageButtons(offsetIndex + 9, offsetIndex + 18);
        }
    }

    public void getLeftPageButtons(int from, int to) {
        List<DocEntry> sliced = this.entries.subList(from, Math.min(to, this.entries.size()));
        boolean offset = to - from == 8;
        for (int i = 0; i < sliced.size(); ++i) {
            DocEntry entry = sliced.get(i);
            DocEntryButton button = new DocEntryButton(this.screenLeft + 19, this.screenTop + 17 + 3 + 16 * i + (offset ? 16 : 0), entry, b -> this.transition(new PageHolderScreen(entry)));
            this.addRenderableWidget((GuiEventListener)button);
            this.buttons.add(button);
        }
    }

    public void getRightPageButtons(int from, int to) {
        if (from > this.entries.size()) {
            return;
        }
        List<DocEntry> sliced = this.entries.subList(from, Math.min(to, this.entries.size()));
        for (int i = 0; i < sliced.size(); ++i) {
            DocEntry entry = sliced.get(i);
            DocEntryButton button = new DocEntryButton(this.screenLeft + 153, this.screenTop + 17 + 3 + 16 * i, entry, b -> this.transition(new PageHolderScreen(entry)));
            this.addRenderableWidget((GuiEventListener)button);
            this.buttons.add(button);
        }
    }
}

