/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.MageBlock;
import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.Color;
import software.bernie.geckolib.util.RenderUtil;

public class AnimBlockRenderer<BOBBY extends AnimBlockSummon>
extends GeoEntityRenderer<BOBBY> {
    public static MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
    protected static final ResourceLocation TEXTURE = ArsNouveau.prefix("textures/entity/anim_block.png");
    public static final ResourceLocation BASE_MODEL = ArsNouveau.prefix("geo/animated_block.geo.json");
    public static final ResourceLocation ANIMATIONS = ArsNouveau.prefix("animations/animated_block_animations.json");
    private final BlockRenderDispatcher dispatcher;
    protected MultiBufferSource bufferSource;

    public AnimBlockRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new GeoModel<BOBBY>(){

            public ResourceLocation getModelResource(BOBBY object) {
                return BASE_MODEL;
            }

            public ResourceLocation getTextureResource(BOBBY object) {
                return TEXTURE;
            }

            public ResourceLocation getAnimationResource(BOBBY animatable) {
                return ANIMATIONS;
            }

            public void setCustomAnimations(BOBBY animatable, long instanceId, AnimationState<BOBBY> customPredicate) {
                super.setCustomAnimations(animatable, instanceId, customPredicate);
                GeoBone head = this.getAnimationProcessor().getBone("block");
                head.setHidden(!(((AnimBlockSummon)animatable).getBlockState().getBlock() instanceof MageBlock));
            }
        });
        this.dispatcher = renderManager.getBlockRenderDispatcher();
    }

    public void render(BOBBY animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (animatable.isDeadOrDying()) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(0.8f, 0.8f, 0.8f);
        super.render(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    public void preRender(PoseStack poseStack, BOBBY animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        this.bufferSource = bufferSource;
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public void renderRecursively(PoseStack poseStack, BOBBY animatable, GeoBone bone, RenderType ty, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.renderRecursively(poseStack, animatable, bone, ty, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (bone.getName().equals("block")) {
            BOBBY animBlock = animatable;
            if (animBlock == null) {
                return;
            }
            BlockState blockstate = ((AnimBlockSummon)animatable).getBlockState();
            if (!(blockstate.getBlock() instanceof MageBlock)) {
                try {
                    Level level = animatable.level();
                    if (blockstate != level.getBlockState(animBlock.blockPosition()) && blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                        poseStack.pushPose();
                        BlockPos blockpos = animBlock.blockPosition().above();
                        RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
                        poseStack.translate(-0.5, -0.5, -0.5);
                        BakedModel model = this.dispatcher.getBlockModel(blockstate);
                        for (RenderType renderType : model.getRenderTypes(blockstate, RandomSource.create((long)blockstate.getSeed(animBlock.blockPosition())), ModelData.EMPTY)) {
                            this.dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, blockstate, blockpos, poseStack, AnimBlockRenderer.buffer.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType)), false, RandomSource.create(), blockstate.getSeed(animBlock.getOnPos()), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
                        }
                        poseStack.popPose();
                        AnimBlockRenderer.buffer.endBatch();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Color getRenderColor(BOBBY animatable, float partialTick, int packedLight) {
        if (animatable != null) {
            ParticleColor color = ParticleColor.fromInt(((AnimBlockSummon)animatable).getColor());
            return Color.ofRGBA((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)0.75f);
        }
        return super.getRenderColor(animatable, partialTick, packedLight);
    }
}

