/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.common.crafting.recipes.BookUpgradeRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.PotionFlaskRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class OneOffRecipesProvider
extends SimpleDataProvider {
    public OneOffRecipesProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        Item[] flasks = new Item[]{(Item)ItemsRegistry.POTION_FLASK.get(), (Item)ItemsRegistry.POTION_FLASK_EXTEND_TIME.get(), (Item)ItemsRegistry.POTION_FLASK_AMPLIFY.get()};
        for (int i = 0; i < flasks.length; ++i) {
            PotionFlaskRecipe flaskRecipe = new PotionFlaskRecipe("", flasks[i].getDefaultInstance(), flasks[i].getDefaultInstance());
            this.saveStable(pOutput, (JsonElement)PotionFlaskRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)flaskRecipe).getOrThrow(), OneOffRecipesProvider.getRecipePath(this.output, "fill_potion_flask_" + i));
        }
        BookUpgradeRecipe apprentice = new BookUpgradeRecipe("", CraftingBookCategory.MISC, ((SpellBook)ItemsRegistry.APPRENTICE_SPELLBOOK.get()).getDefaultInstance(), (NonNullList<Ingredient>)NonNullList.copyOf(List.of(Ingredient.of((ItemStack[])new ItemStack[]{((SpellBook)ItemsRegistry.NOVICE_SPELLBOOK.get()).getDefaultInstance()}), Ingredient.of((TagKey)Tags.Items.OBSIDIANS), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((TagKey)Tags.Items.RODS_BLAZE), Ingredient.of((TagKey)Tags.Items.RODS_BLAZE))));
        BookUpgradeRecipe archmage = new BookUpgradeRecipe("", CraftingBookCategory.MISC, ((SpellBook)ItemsRegistry.ARCHMAGE_SPELLBOOK.get()).getDefaultInstance(), (NonNullList<Ingredient>)NonNullList.copyOf(List.of(Ingredient.of((ItemStack[])new ItemStack[]{((SpellBook)ItemsRegistry.APPRENTICE_SPELLBOOK.get()).getDefaultInstance()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), Ingredient.of((ItemLike[])new ItemLike[]{Items.TOTEM_OF_UNDYING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_STAR}), Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.WILDEN_TRIBUTE}))));
        this.saveStable(pOutput, (JsonElement)BookUpgradeRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)apprentice).getOrThrow(), OneOffRecipesProvider.getRecipePath(this.output, "apprentice_book_upgrade"));
        this.saveStable(pOutput, (JsonElement)BookUpgradeRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)archmage).getOrThrow(), OneOffRecipesProvider.getRecipePath(this.output, "archmage_book_upgrade"));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipe/" + id + ".json");
    }

    public String getName() {
        return "Grab bag Datagen";
    }
}

