/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public class TickEmitterPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<TickEmitterPacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("tick_emitter"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TickEmitterPacket> CODEC = StreamCodec.ofMember(TickEmitterPacket::toBytes, TickEmitterPacket::new);
    ParticleEmitter emitter;

    public TickEmitterPacket(ParticleEmitter emitter) {
        this.emitter = emitter;
    }

    public TickEmitterPacket(RegistryFriendlyByteBuf buf) {
        this.emitter = (ParticleEmitter)ParticleEmitter.STREAM.decode((Object)buf);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        ParticleEmitter.STREAM.encode((Object)buf, (Object)this.emitter);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        super.onClientReceived(minecraft, player);
        this.emitter.tick(player.level);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

