/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.email;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.CharArraySet;
import org.apache.lucene.ars_nouveau.analysis.LowerCaseFilter;
import org.apache.lucene.ars_nouveau.analysis.StopFilter;
import org.apache.lucene.ars_nouveau.analysis.StopwordAnalyzerBase;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.email.UAX29URLEmailTokenizer;
import org.apache.lucene.ars_nouveau.analysis.en.EnglishAnalyzer;

public final class UAX29URLEmailAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;

    public UAX29URLEmailAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public UAX29URLEmailAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public UAX29URLEmailAnalyzer(Reader stopwords) throws IOException {
        this(UAX29URLEmailAnalyzer.loadStopwordSet(stopwords));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        UAX29URLEmailTokenizer src = new UAX29URLEmailTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new LowerCaseFilter(src);
        tok = new StopFilter(tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.maxTokenLength);
            src.setReader((Reader)r);
        }, (TokenStream)tok);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

