/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.IndriAndQuery;
import org.apache.lucene.ars_nouveau.search.IndriAndScorer;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.ScorerSupplier;
import org.apache.lucene.ars_nouveau.search.Weight;

public class IndriAndWeight
extends Weight {
    private final IndriAndQuery query;
    private final ArrayList<Weight> weights;
    private final ScoreMode scoreMode;
    private final float boost;

    public IndriAndWeight(IndriAndQuery query, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        super(query);
        this.query = query;
        this.boost = boost;
        this.scoreMode = scoreMode;
        this.weights = new ArrayList();
        for (BooleanClause c : query) {
            Weight w = searcher.createWeight(c.query(), scoreMode, 1.0f);
            this.weights.add(w);
        }
    }

    private Scorer getScorer(LeafReaderContext context) throws IOException {
        ArrayList<Scorer> subScorers = new ArrayList<Scorer>();
        for (Weight w : this.weights) {
            Scorer scorer = w.scorer(context);
            if (scorer == null) continue;
            subScorers.add(scorer);
        }
        if (subScorers.isEmpty()) {
            return null;
        }
        Scorer scorer = (Scorer)subScorers.get(0);
        if (subScorers.size() > 1) {
            scorer = new IndriAndScorer(subScorers, this.scoreMode, this.boost);
        }
        return scorer;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        for (Weight w : this.weights) {
            if (w.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        boolean fail = false;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Explanation e = w.explain(context, doc);
            if (e.isMatch()) {
                subs.add(e);
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.query().toString() + ")", e));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        Scorer scorer = this.scorer(context);
        if (scorer != null) {
            int advanced = scorer.iterator().advance(doc);
            assert (advanced == doc);
            return Explanation.match((Number)Float.valueOf(scorer.score()), "sum of:", subs);
        }
        return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        Scorer scorer = this.getScorer(context);
        if (scorer == null) {
            return null;
        }
        return new Weight.DefaultScorerSupplier(scorer);
    }
}

