/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import me.axieum.mcmod.authme.api.AuthMe;
import me.axieum.mcmod.authme.api.Config;
import me.axieum.mcmod.authme.api.gui.screen.MicrosoftAuthScreen;
import me.axieum.mcmod.authme.api.gui.screen.OfflineAuthScreen;
import me.axieum.mcmod.authme.api.util.SessionUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class AuthMethodScreen
extends Screen {
    private final Screen parentScreen;
    public static final WidgetSprites MICROSOFT_BUTTON_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/microsoft_button"), ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/microsoft_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/microsoft_button_focused"));
    public static final WidgetSprites MOJANG_BUTTON_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/mojang_button"), ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/mojang_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/mojang_button_focused"));
    public static final WidgetSprites OFFLINE_BUTTON_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/offline_button"), ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/offline_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"authme", (String)"widget/offline_button_focused"));

    public AuthMethodScreen(Screen parentScreen) {
        super((Component)Component.translatable((String)"gui.authme.method.title"));
        this.parentScreen = parentScreen;
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        StringWidget titleWidget = new StringWidget(this.width, this.height, this.title, this.font);
        titleWidget.setColor(0xFFFFFF);
        titleWidget.setPosition(this.width / 2 - titleWidget.getWidth() / 2, this.height / 2 - titleWidget.getHeight() / 2 - 22);
        this.addRenderableWidget((GuiEventListener)titleWidget);
        StringWidget greetingWidget = new StringWidget(this.width, this.height, (Component)Component.translatable((String)"gui.authme.method.greeting", (Object[])new Object[]{Component.literal((String)SessionUtils.getUser().getName()).withStyle(ChatFormatting.YELLOW)}), this.font);
        greetingWidget.setColor(0xA0A0A0);
        greetingWidget.setPosition(this.width / 2 - greetingWidget.getWidth() / 2, this.height / 2 - greetingWidget.getHeight() / 2 - 42);
        this.addRenderableWidget((GuiEventListener)greetingWidget);
        ImageButton msButton = new ImageButton(this.width / 2 - 20 - 10 - 4, this.height / 2 - 5, 20, 20, MICROSOFT_BUTTON_TEXTURES, button -> {
            boolean selectAccount = InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)341);
            if (Config.LoginMethods.Microsoft.isDefaults()) {
                this.minecraft.setScreen((Screen)new MicrosoftAuthScreen(this, this.parentScreen, selectAccount));
            } else {
                AuthMe.LOGGER.warn("Non-default Microsoft authentication URLs are in use!");
                ConfirmScreen confirmScreen = new ConfirmScreen(a -> this.minecraft.setScreen(a ? new MicrosoftAuthScreen(this, this.parentScreen, selectAccount) : this), (Component)Component.translatable((String)"gui.authme.microsoft.warning.title"), (Component)Component.translatable((String)"gui.authme.microsoft.warning.body"), (Component)Component.translatable((String)"gui.authme.microsoft.warning.accept"), (Component)Component.translatable((String)"gui.authme.microsoft.warning.cancel"));
                this.minecraft.setScreen((Screen)confirmScreen);
                confirmScreen.setDelay(40);
            }
        }, (Component)Component.translatable((String)"gui.authme.method.button.microsoft"));
        msButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.authme.method.button.microsoft").append("\n").append((Component)Component.translatable((String)"gui.authme.method.button.microsoft.selectAccount").withStyle(ChatFormatting.GRAY))));
        this.addRenderableWidget((GuiEventListener)msButton);
        ImageButton mojangButton = new ImageButton(this.width / 2 - 10, this.height / 2 - 5, 20, 20, MOJANG_BUTTON_TEXTURES, ConfirmLinkScreen.confirmLink((Screen)this, (String)"https://aka.ms/MinecraftPostMigrationFAQ"), (Component)Component.translatable((String)"gui.authme.method.button.mojang"));
        mojangButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.authme.method.button.mojang").append("\n").append((Component)Component.translatable((String)"gui.authme.method.button.mojang.unavailable").withStyle(ChatFormatting.GRAY))));
        this.addRenderableWidget((GuiEventListener)mojangButton);
        ImageButton offlineButton = new ImageButton(this.width / 2 + 10 + 4, this.height / 2 - 5, 20, 20, OFFLINE_BUTTON_TEXTURES, button -> this.minecraft.setScreen((Screen)new OfflineAuthScreen(this, this.parentScreen)), (Component)Component.translatable((String)"gui.authme.method.button.offline"));
        offlineButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.authme.method.button.offline")));
        this.addRenderableWidget((GuiEventListener)offlineButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), button -> this.onClose()).bounds(this.width / 2 - 50, this.height / 2 + 27, 100, 20).build());
    }

    public void onClose() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
        }
    }
}

