/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.container.base;

import com.traverse.bhc.common.items.BaseHeartCanister;
import com.traverse.bhc.common.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerCopySlot;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoulContainerMenu
extends AbstractContainerMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoulContainerMenu.class);
    protected final int containerSlotId;
    protected final ComponentItemHandler itemStackHandler;
    protected final Inventory playerInventory;
    protected final int slotCount;

    public SoulContainerMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, int slotCount, int containerSlotId) {
        super(menuType, containerId);
        this.playerInventory = playerInventory;
        this.containerSlotId = containerSlotId;
        ItemStack stack = playerInventory.getItem(containerSlotId);
        this.itemStackHandler = InventoryUtil.createVirtualInventory(slotCount, stack);
        this.slotCount = slotCount;
        if (!stack.is(this.getContainerItem())) {
            LOGGER.error("Item in slot {} of player {} was not of expected type, closing menu!", (Object)containerSlotId, (Object)playerInventory.player.getGameProfile().getName());
            playerInventory.player.closeContainer();
        }
    }

    public static int getSlotIdForHand(Player player, InteractionHand hand) {
        int slotId;
        if (hand == InteractionHand.MAIN_HAND) {
            slotId = player.getInventory().selected;
            if (!Inventory.isHotbarSlot((int)slotId)) {
                LOGGER.error("Unable to find main hand slot for player {}", (Object)player.getGameProfile().getName());
            }
        } else {
            slotId = 40;
        }
        return slotId;
    }

    public static void writeSlotId(RegistryFriendlyByteBuf byteBuf, int slotId) {
        byteBuf.writeVarInt(slotId);
    }

    public static int readSlotId(RegistryFriendlyByteBuf byteBuf) {
        return byteBuf.readVarInt();
    }

    protected void addPlayerInventory() {
        for (int idx = 0; idx < 9; ++idx) {
            int x = 8 + idx * 18;
            int y = 142;
            if (idx == this.containerSlotId) {
                this.addSlot(new LockedSlot(this.playerInventory, idx, x, y));
                continue;
            }
            this.addSlot(new Slot((Container)this.playerInventory, idx, x, y));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = 84 + row * 18;
                this.addSlot(new Slot((Container)this.playerInventory, col + row * 9 + 9, x, y));
            }
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index < this.itemStackHandler.getSlots() ? !this.moveItemStackTo(slotStack, this.itemStackHandler.getSlots(), this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, this.itemStackHandler.getSlots(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    protected abstract Holder<Item> getContainerItem();

    public boolean stillValid(Player player) {
        return player.getInventory().getItem(this.containerSlotId).is(this.getContainerItem());
    }

    public static class LockedSlot
    extends Slot {
        public LockedSlot(Inventory inventoryIn, int index, int xPosition, int yPosition) {
            super((Container)inventoryIn, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player playerIn) {
            return false;
        }
    }

    public static class SlotPendant
    extends ItemHandlerCopySlot {
        private final int slotIndex;

        public SlotPendant(ComponentItemHandler itemHandler, int slotIndex, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, slotIndex, xPosition, yPosition);
            this.slotIndex = slotIndex;
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return super.mayPlace(stack) && stack.getItem() instanceof BaseHeartCanister && ((BaseHeartCanister)stack.getItem()).getType().ordinal() == this.slotIndex;
        }
    }
}

