/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.block.custom;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import net.ricmc.betterblockz.block.ModBlocks;
import org.jetbrains.annotations.NotNull;

public class VariantShufflerBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final int TICK_INTERVAL = 100;
    private static final int TICK_JITTER = 40;
    private static final Map<Block, List<Block>> VARIANT_CACHE = new HashMap<Block, List<Block>>();

    public VariantShufflerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!level.isClientSide && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            this.scheduleNextTick(level, pos);
        }
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        boolean powered = level.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
            if (!powered) {
                this.scheduleNextTick(level, pos);
            }
        }
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return;
        }
        boolean changed = false;
        for (Direction dir : Direction.values()) {
            BlockPos targetPos = pos.relative(dir);
            if (!level.isLoaded(targetPos)) continue;
            changed |= this.cycleVariant((Level)level, targetPos);
        }
        if (changed && !level.hasNeighborSignal(pos)) {
            this.scheduleNextTick((Level)level, pos);
        }
    }

    private void scheduleNextTick(Level level, BlockPos pos) {
        int delay = 100 + level.getRandom().nextInt(40);
        level.scheduleTick(pos, (Block)this, delay, TickPriority.NORMAL);
    }

    private boolean cycleVariant(Level level, BlockPos pos) {
        BlockState currentState = level.getBlockState(pos);
        Block currentBlock = currentState.getBlock();
        List<Block> variants = this.getVariants(currentBlock);
        if (variants.size() <= 1) {
            return false;
        }
        int currentIndex = variants.indexOf(currentBlock);
        if (currentIndex < 0) {
            return false;
        }
        int nextIndex = (currentIndex + 1 + level.getRandom().nextInt(variants.size() - 1)) % variants.size();
        Block nextBlock = variants.get(nextIndex);
        BlockState newState = nextBlock.defaultBlockState();
        if (currentState.hasProperty((Property)BlockStateProperties.FACING) && newState.hasProperty((Property)BlockStateProperties.FACING)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)currentState.getValue((Property)BlockStateProperties.FACING)));
        }
        if (!newState.equals(currentState)) {
            level.setBlock(pos, newState, 2);
            return true;
        }
        return false;
    }

    private List<Block> getVariants(Block baseBlock) {
        return VARIANT_CACHE.computeIfAbsent(baseBlock, b -> {
            String baseName = VariantShufflerBlock.getBaseName(b);
            return ModBlocks.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get()).filter(v -> VariantShufflerBlock.getBaseName(v).equals(baseName)).sorted(Comparator.comparingInt(this::extractIndex)).collect(Collectors.toList());
        });
    }

    private static String getBaseName(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (key == null) {
            return "unknown";
        }
        String path = key.getPath();
        int underscore = path.lastIndexOf("_");
        return underscore != -1 ? path.substring(0, underscore) : path;
    }

    private int extractIndex(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (key == null) {
            return Integer.MAX_VALUE;
        }
        String path = key.getPath();
        int underscore = path.lastIndexOf("_");
        if (underscore != -1) {
            try {
                return Integer.parseInt(path.substring(underscore + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }
}

