/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.client.screen;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.network.ModPayloads;
import org.jetbrains.annotations.NotNull;

public class BlockZVariantSelectorScreen
extends Screen {
    private final ItemStack heldStack;
    private List<Item> variants;
    private int selectedIndex = -1;
    private int currentIndex = -1;
    private int lastHoveredIndex = -1;

    public BlockZVariantSelectorScreen(ItemStack stack) {
        super((Component)Component.literal((String)"Select Variant"));
        this.heldStack = stack;
    }

    protected void init() {
        super.init();
        if (!(this.heldStack.getItem() instanceof BlockItem)) {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        Block heldBlock = ((BlockItem)this.heldStack.getItem()).getBlock();
        this.variants = ModBlocks.VARIANTS.values().stream().filter(arr -> Arrays.stream(arr).anyMatch(def -> def.get() == heldBlock)).flatMap(arr -> Arrays.stream(arr).map(def -> ((Block)def.get()).asItem())).toList();
        if (this.variants.isEmpty()) {
            if (ModBlocks.CYBERLIGHT_THIN.stream().anyMatch(def -> def.get() == heldBlock)) {
                this.variants = ModBlocks.CYBERLIGHT_THIN.stream().map(def -> ((Block)def.get()).asItem()).toList();
            } else if (ModBlocks.CYBERLIGHT_THIN_ALT.stream().anyMatch(def -> def.get() == heldBlock)) {
                this.variants = ModBlocks.CYBERLIGHT_THIN_ALT.stream().map(def -> ((Block)def.get()).asItem()).toList();
            } else if (ModBlocks.CYBERLIGHT_BAR.stream().anyMatch(def -> def.get() == heldBlock)) {
                this.variants = ModBlocks.CYBERLIGHT_BAR.stream().map(def -> ((Block)def.get()).asItem()).toList();
            } else if (ModBlocks.CYBERLIGHT_BAR_VERTICAL.stream().anyMatch(def -> def.get() == heldBlock)) {
                this.variants = ModBlocks.CYBERLIGHT_BAR_VERTICAL.stream().map(def -> ((Block)def.get()).asItem()).toList();
            }
        }
        Item heldItem = this.heldStack.getItem();
        for (int i = 0; i < this.variants.size(); ++i) {
            if (this.variants.get(i) != heldItem) continue;
            this.currentIndex = i;
            break;
        }
        this.selectedIndex = this.currentIndex;
    }

    private int getGridStartY(int gridHeight) {
        int previewSize = 48;
        int nameGap = 6;
        int gapBetweenNameAndGrid = 4;
        Objects.requireNonNull(Minecraft.getInstance().font);
        int nameHeight = 9;
        int totalHeight = previewSize + nameGap + nameHeight + gapBetweenNameAndGrid + gridHeight;
        int topY = (this.height - totalHeight) / 2;
        int nameY = topY + previewSize + nameGap;
        return nameY + nameHeight + gapBetweenNameAndGrid;
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        ItemStack previewStack;
        if (this.variants == null || this.variants.isEmpty()) {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        int spacing = 20;
        int columns = 5;
        int rows = (int)Math.ceil((double)this.variants.size() / (double)columns);
        int gridWidth = columns * spacing;
        int gridHeight = rows * spacing;
        int xStart = this.width / 2 - gridWidth / 2;
        int yStart = this.getGridStartY(gridHeight);
        float previewScale = 3.0f;
        int previewSize = (int)(16.0f * previewScale);
        Objects.requireNonNull(mc.font);
        int previewY = yStart - previewSize - 9 - 14;
        int padding = 8;
        int bgColor = -1442840576;
        gui.fill(xStart - padding, previewY - padding, xStart + gridWidth + padding, yStart + gridHeight + padding, bgColor);
        int hoveredIndex = -1;
        for (int i = 0; i < this.variants.size(); ++i) {
            int col = i % columns;
            int row = i / columns;
            int iconX = xStart + col * spacing;
            int iconY = yStart + row * spacing;
            if (mouseX < iconX || mouseX >= iconX + 16 || mouseY < iconY || mouseY >= iconY + 16) continue;
            hoveredIndex = i;
            this.selectedIndex = i;
            break;
        }
        if (hoveredIndex >= 0) {
            this.lastHoveredIndex = hoveredIndex;
        }
        int previewIndex = this.lastHoveredIndex >= 0 ? this.lastHoveredIndex : this.currentIndex;
        ItemStack itemStack = previewStack = previewIndex >= 0 && previewIndex < this.variants.size() ? new ItemStack((ItemLike)this.variants.get(previewIndex)) : null;
        if (previewStack != null) {
            int previewXCentered = this.width / 2 - previewSize / 2;
            gui.pose().pushPose();
            gui.pose().translate((float)previewXCentered, (float)previewY, 200.0f);
            gui.pose().scale(previewScale, previewScale, previewScale);
            gui.renderItem(previewStack, 0, 0);
            gui.pose().popPose();
            Component name = previewStack.getHoverName();
            int rawWidth = mc.font.width((FormattedText)name);
            float scale = rawWidth > gridWidth ? (float)gridWidth / (float)rawWidth : 1.0f;
            int scaledWidth = (int)((float)rawWidth * scale);
            int nameX = this.width / 2 - scaledWidth / 2;
            int nameY = previewY + previewSize + 6;
            gui.pose().pushPose();
            gui.pose().translate((float)nameX, (float)nameY, 0.0f);
            gui.pose().scale(scale, scale, 1.0f);
            gui.drawString(mc.font, name, 0, 0, 0xFFFFFF, false);
            gui.pose().popPose();
        }
        for (int i = 0; i < this.variants.size(); ++i) {
            Item item = this.variants.get(i);
            int col = i % columns;
            int row = i / columns;
            int iconX = xStart + col * spacing;
            int iconY = yStart + row * spacing;
            gui.renderItem(new ItemStack((ItemLike)item), iconX, iconY);
            if (hoveredIndex != i) continue;
            gui.fill(iconX - 2, iconY - 2, iconX + 18, iconY + 18, -2130706433);
        }
        super.render(gui, mouseX, mouseY, partialTicks);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.variants == null || this.variants.isEmpty()) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        int spacing = 20;
        int columns = 5;
        int rows = (int)Math.ceil((double)this.variants.size() / (double)columns);
        int gridWidth = columns * spacing;
        int gridHeight = rows * spacing;
        int xStart = this.width / 2 - gridWidth / 2;
        int yStart = this.getGridStartY(gridHeight);
        if (this.selectedIndex >= 0 && button == 0) {
            int col = this.selectedIndex % columns;
            int row = this.selectedIndex / columns;
            int iconX = xStart + col * spacing;
            int iconY = yStart + row * spacing;
            if (mouseX >= (double)iconX && mouseX < (double)(iconX + 16) && mouseY >= (double)iconY && mouseY < (double)(iconY + 16)) {
                ModPayloads.sendSetVariant(this.selectedIndex);
                Minecraft.getInstance().setScreen(null);
                return true;
            }
        }
        if (button == 0) {
            boolean insideGrid;
            boolean bl = insideGrid = mouseX >= (double)xStart && mouseX < (double)(xStart + gridWidth) && mouseY >= (double)yStart && mouseY < (double)(yStart + gridHeight);
            if (!insideGrid) {
                Minecraft.getInstance().setScreen(null);
                return true;
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

