/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.datagen;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.util.ModColorSets;
import org.jetbrains.annotations.NotNull;

public class BetterBlockZLangProvider
extends LanguageProvider {
    public BetterBlockZLangProvider(@NotNull DataGenerator generator) {
        super(generator.getPackOutput(), "betterblockz", "en_us");
    }

    protected void addTranslations() {
        HashMap<Object, Object> langEntries = new HashMap<Object, Object>();
        langEntries.put("key.categories.betterblockz", "BetterBlockZ Controls");
        langEntries.put("key.betterblockz.switch", "Switch BlockZ Variant Screen");
        langEntries.put("key.betterblockz.scroll_modifier", "BlockZ Mouse Scroll Modifier");
        langEntries.put("tooltip.betterblockz.block", "\u00a77Cycle Variants: \u00a7e[Shift]");
        langEntries.put("tooltip.betterblockz.block.shift", "\u00a77\u2022 Sneak + Right-Click (air)");
        langEntries.put("tooltip.betterblockz.block.shift.line2", "\u00a77\u2022 \u00a7e%s \u00a77+ \u00a7eMouse Wheel \u00a77to scroll variants");
        langEntries.put("tooltip.betterblockz.block.shift.line3", "\u00a77\u2022 \u00a7ePress %s \u00a77to open \u00a7eVariant Selector");
        langEntries.put("tooltip.betterblockz.block.shift.line4", "\u00a77\u2022 Use \u00a7eBlockZ Cycler \u00a77on placed blocks");
        langEntries.put("tooltip.betterblockz.block.shift.line5", "\u00a77\u2022 Supports \u00a7eStonecutter Recipes \u00a77for automation");
        langEntries.put("creativetab.better_blockz.blockz_blocks", "BetterBlockZ");
        langEntries.put("block.betterblockz.transmuter_blockz.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info.");
        langEntries.put("block.betterblockz.transmuter_blockz.shift.line1", "Transforms nearby Cobblestone using catalysts below:");
        langEntries.put("block.betterblockz.transmuter_blockz.shift.line2", "Lava \u2192 Cobbled Deepslate");
        langEntries.put("block.betterblockz.transmuter_blockz.shift.line3", "Water \u2192 Mossy Cobblestone");
        langEntries.put("block.betterblockz.number_blockz.tooltip", "Right-Click to change number (0\u20139)");
        langEntries.put("block.betterblockz.tank_blockz.tooltip", "Explosion Resistant");
        for (Map.Entry<String, DeferredBlock<?>[]> entry : ModBlocks.VARIANTS.entrySet()) {
            if (!entry.getKey().startsWith("zeon")) continue;
            for (DeferredBlock<?> def : entry.getValue()) {
                String blockName = def.getId().getPath();
                langEntries.put("block.betterblockz." + blockName + ".tooltip", "Full Glow Light Block");
            }
        }
        langEntries.put("item.betterblockz.omni_spade", "\u00a76BlockZ Cycler\u00a7r");
        langEntries.put("item.betterblockz.omni_spade.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.omni_spade.shift.line1", "\u00a77Right-Click block to \u00a7aCycle Variant\u00a7r");
        langEntries.put("item.betterblockz.omni_spade.shift.line2", "\u00a77Sneak + Right-Click to \u00a7cCycle Back\u00a7r");
        langEntries.put("item.betterblockz.omni_spade.shift.line3", "\u00a77Sneak + Right-Click air to \u00a7bChange Mode\u00a7r");
        langEntries.put("item.betterblockz.checkered_spade", "\u00a76BlockZ Checkered Cycler\u00a7r");
        langEntries.put("item.betterblockz.checkered_spade.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.checkered_spade.shift.line1", "\u00a77Right-Click block to \u00a7aCycle Variant\u00a7r");
        langEntries.put("item.betterblockz.checkered_spade.shift.line2", "\u00a77Sneak + Right-Click to \u00a7cCycle Back\u00a7r");
        langEntries.put("item.betterblockz.checkered_spade.shift.line3", "\u00a77Sneak + Right-Click air to \u00a7bChange Mode\u00a7r");
        langEntries.put("item.betterblockz.cobble_crafter", "\u00a76BlockZ Crafter\u00a7r");
        langEntries.put("item.betterblockz.cobble_crafter.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.cobble_crafter.shift.line1", "\u00a77Right-Click air to \u00a7aOpen Crafting\u00a7r");
        langEntries.put("item.betterblockz.cobble_crafter.shift.line2", "\u00a77Sneak + Right-Click block to \u00a7bChange Mode\u00a7r");
        langEntries.put("item.betterblockz.block_replacer", "\u00a76BlockZ Replacer\u00a7r");
        langEntries.put("item.betterblockz.block_replacer.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.block_replacer.shift.line1", "\u00a77Right-Click block to \u00a7aSelect\u00a7r");
        langEntries.put("item.betterblockz.block_replacer.shift.line2", "\u00a77Sneak + Right-Click air to \u00a7bChange Mode\u00a7r");
        langEntries.put("item.betterblockz.auto_placer", "\u00a76BlockZ Placer\u00a7r");
        langEntries.put("item.betterblockz.auto_placer.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.auto_placer.shift.line1", "\u00a77Sneak + Right-Click block to \u00a7aSelect\u00a7r");
        langEntries.put("item.betterblockz.auto_placer.shift.line2", "\u00a77Sneak + Right-Click air to \u00a7bChange Mode\u00a7r");
        langEntries.put("item.betterblockz.auto_placer.shift.line3", "\u00a77Modes: \u00a7bLine\u00a77 7, 21 | \u00a7bArea\u00a77 7\u00d77, 21\u00d721\u00a7r");
        langEntries.put("item.betterblockz.auto_placer.shift.line4", "\u00a77Sneak + Right-Click last blocks to \u00a7cUndo\u00a7r");
        langEntries.put("item.betterblockz.block_extend", "\u00a76BlockZ Extender\u00a7r");
        langEntries.put("item.betterblockz.block_extend.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.block_extend.shift.line1", "\u00a77Extends \u00a7amatching blocks\u00a7r");
        langEntries.put("item.betterblockz.block_extend.shift.line2", "\u00a77Sneak + Right-Click air to \u00a7bChange Mode\u00a7r");
        langEntries.put("item.betterblockz.color_changer", "\u00a76BlockZ Color Changer\u00a7r");
        langEntries.put("item.betterblockz.color_changer.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.color_changer.shift.line1", "\u00a77Right-Click block to \u00a7aCycle Color\u00a7r");
        langEntries.put("item.betterblockz.color_changer.shift.line2", "\u00a77Sneak + Right-Click to \u00a7cCycle Back\u00a7r");
        langEntries.put("item.betterblockz.color_changer.shift.line3", "\u00a77Sneak + Right-Click air to \u00a7bChange Mode\u00a7r");
        langEntries.put("tooltip.betterblockz.supported_sets", "Supported Block Sets");
        langEntries.put("tooltip.betterblockz.color_support", "Zeon, Zeno");
        langEntries.put("item.betterblockz.block_disconnect", "\u00a76BlockZ CTM Toggle Tool\u00a7r");
        langEntries.put("item.betterblockz.block_disconnect.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.block_disconnect.shift.line1", "\u00a77Right-Click CTM block variant to \u00a7aConnect/Disconnect\u00a7r");
        langEntries.put("item.betterblockz.block_randomizer", "\u00a76BlockZ Pattern Randomizer\u00a7r");
        langEntries.put("item.betterblockz.block_randomizer.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.block_randomizer.shift.line1", "\u00a77Right-Click blocks to \u00a7aApply Random Patterns\u00a7r");
        langEntries.put("item.betterblockz.block_randomizer.shift.line2", "\u00a77Sneak + Right-Click air to \u00a7bChange Mode\u00a7r");
        langEntries.put("item.betterblockz.meta_wand", "\u00a76BlockZ Master\u00a7r");
        langEntries.put("item.betterblockz.better_builder", "\u00a76BlockZ Palette \u00a7b(Creative)\u00a7r");
        langEntries.put("item.betterblockz.better_builder.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.better_builder.shift", "\u00a7aPlaces\u00a77 a full \u00a7bBetterBlockZ\u00a77 set instantly\u00a7r");
        langEntries.put("item.betterblockz.checkered_builder", "\u00a76BlockZ Pattern \u00a7b(Creative)\u00a7r");
        langEntries.put("item.betterblockz.checkered_builder.tooltip", "\u00a77Press \u00a7e[Shift]\u00a77 for Info\u00a7r");
        langEntries.put("item.betterblockz.checkered_builder.shift", "\u00a7aPlaces\u00a77 a checkered \u00a7bBetterBlockZ\u00a77 pattern\u00a7r");
        langEntries.put("block.betterblockz.dirt_blockz", "BlockZ Dirt");
        langEntries.put("block.betterblockz.stone_blockz", "BlockZ Stone");
        langEntries.put("block.betterblockz.aurora_blockz", "BlockZ Aurora");
        langEntries.put("block.betterblockz.ztone_blockz", "Ztone Tile");
        langEntries.put("block.betterblockz.z_moving", "Better BlockZ");
        langEntries.put("block.betterblockz.variant_shuffler", "Variant Shuffler Block");
        langEntries.put("block.betterblockz.flat_lamp", "Flat Lamp (Transparent)");
        langEntries.put("block.betterblockz.blockz_core", "BlockZ Core");
        langEntries.put("block.betterblockz.transmuter_blockz", "Cobblestone Transmuter");
        Map variantBaseNames = Map.ofEntries(Map.entry("ambercore_blockz", "Amber Core"), Map.entry("bitt_blockz", "Bitt"), Map.entry("korp_blockz", "Korp"), Map.entry("vena_blockz", "Vena"), Map.entry("vect_blockz", "Vect"), Map.entry("copper_blockz", "Luxe Copper"), Map.entry("iron_blockz", "Luxe Iron"), Map.entry("gold_blockz", "Luxe Gold"), Map.entry("diamond_blockz", "Luxe Diamond"), Map.entry("forgecopper_blockz", "Forge Copper"), Map.entry("ironslate_blockz", "Iron Slate"), Map.entry("hazard_blockz", "Hazard BlockZ"), Map.entry("lave_blockz", "Lave"), Map.entry("azur_blockz", "Azur"), Map.entry("jelt_blockz", "Jelt"), Map.entry("eclipse_blockz", "Eclipse"), Map.entry("synthalloy_blockz", "Synth Alloy"), Map.entry("crimson_blockz", "Crimson Slate"), Map.entry("ironslateredstone_blockz", "Iron Slate: Redstone"), Map.entry("lablink_blockz", "Lab Link"), Map.entry("stone_blockz", "Polished Stone"), Map.entry("mint_blockz", "Mint"), Map.entry("cyberlight_secret_blockz", "Cyber Light Secret"), Map.entry("cray_blockz", "Cray"), Map.entry("reed_blockz", "Reed"), Map.entry("ztyl_blockz", "Ztyl"), Map.entry("iszm_blockz", "Iszm"), Map.entry("fort_blockz", "Fort"), Map.entry("zane_blockz", "Zane"), Map.entry("lairblood_blockz", "Lair Blood"), Map.entry("lairflesh_blockz", "Lair Flesh"), Map.entry("lairhusk_blockz", "Lair Husk"), Map.entry("lairdecay_blockz", "Lair Decay"), Map.entry("lairstain_blockz", "Lair Stain"), Map.entry("zoea_blockz", "Zoea"), Map.entry("armz_blockz", "Armz"), Map.entry("tank_blockz", "Tank"), Map.entry("kryp_blockz", "Kryp"), Map.entry("metalzone_iron_blockz", "Metal Zone Iron"), Map.entry("metalzone_rustyiron_blockz", "Metal Zone Rusty Iron"), Map.entry("metalzone_copper_blockz", "Metal Zone Copper"), Map.entry("metalzone_rustycopper_blockz", "Metal Zone Oxidized Copper"));
        Map variantExceptions = Map.ofEntries(Map.entry("hazard_blockz_0", "Hazard BlockZ Caution"), Map.entry("hazard_blockz_1", "Hazard BlockZ Caution Faded"), Map.entry("hazard_blockz_2", "Hazard BlockZ Danger"), Map.entry("hazard_blockz_3", "Hazard BlockZ Danger Faded"), Map.entry("hazard_blockz_4", "Hazard BlockZ Construction"), Map.entry("hazard_blockz_5", "Hazard BlockZ Construction Faded"), Map.entry("hazard_blockz_6", "Hazard BlockZ Safe"), Map.entry("hazard_blockz_7", "Hazard BlockZ Safe Faded"), Map.entry("hazard_blockz_8", "Hazard BlockZ Info"), Map.entry("hazard_blockz_9", "Hazard BlockZ Info Faded"));
        Map COLOR_NAMES = Map.ofEntries(Map.entry(0, "White"), Map.entry(1, "Light Gray"), Map.entry(2, "Gray"), Map.entry(3, "Black"), Map.entry(4, "Brown"), Map.entry(5, "Red"), Map.entry(6, "Orange"), Map.entry(7, "Yellow"), Map.entry(8, "Lime"), Map.entry(9, "Green"), Map.entry(10, "Cyan"), Map.entry(11, "Light Blue"), Map.entry(12, "Blue"), Map.entry(13, "Purple"), Map.entry(14, "Magenta"), Map.entry(15, "Pink"));
        Map COLOR_SETS = Map.ofEntries(Map.entry("cyberlight_blockz", "Cyber Light"), Map.entry("cyberlight_alt_blockz", "Cyber Light \u25c7"), Map.entry("cyberlight_thin", "Cyber Light Flat"), Map.entry("cyberlight_thin_alt", "Cyber Light Panel"), Map.entry("myst_blockz", "Myst"), Map.entry("agon_blockz", "Agon"), Map.entry("tintedglass_blockz", "Tinted Glass"), Map.entry("zoea_0_blockz", "Zoea Base"), Map.entry("zoea_1_blockz", "Zoea 1"), Map.entry("zoea_2_blockz", "Zoea 2"), Map.entry("zoea_3_blockz", "Zoea 3"), Map.entry("number_blockz", "Number Decal"), Map.entry("cyberlight_bar", "Cyber Light Bar"), Map.entry("cyberlight_bar_vertical", "Cyber Light Bar (Vertical)"), Map.entry("zenohex_blockz", "Zeno Hex"));
        block6: for (Block block : BuiltInRegistries.BLOCK) {
            String baseName;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if (!id.getNamespace().equals("betterblockz")) continue;
            String path = id.getPath();
            for (Map.Entry entry : COLOR_SETS.entrySet()) {
                String baseKey = (String)entry.getKey();
                if (!path.startsWith(baseKey + "_")) continue;
                baseName = (String)entry.getValue();
                try {
                    int colorIndex = Integer.parseInt(path.substring((baseKey + "_").length()));
                    String colorName = COLOR_NAMES.getOrDefault(colorIndex, "Unknown");
                    langEntries.put("block.betterblockz." + path, baseName + " " + colorName);
                }
                catch (NumberFormatException colorIndex) {}
            }
            if (variantExceptions.containsKey(path)) {
                langEntries.put("block.betterblockz." + path, (String)variantExceptions.get(path));
                continue;
            }
            for (ModColorSets.SetColor colorEnum : ModColorSets.SetColor.values()) {
                String colorId = colorEnum.id();
                String[] parts = path.split("_blockz_");
                if (parts.length != 2) continue;
                String left = parts[0];
                String variant = parts[1];
                if (!left.endsWith(colorId)) continue;
                String[] familySplit = left.split("_" + colorId);
                String familyName = familySplit[0];
                String family = BetterBlockZLangProvider.capitalizeWords(familyName);
                String color = BetterBlockZLangProvider.capitalizeWords(colorId);
                String displayName = family + " " + color;
                displayName = displayName + (String)(variant.equals("0") ? " Base" : " " + variant);
                langEntries.put("block.betterblockz." + path, displayName);
            }
            for (Map.Entry entry : variantBaseNames.entrySet()) {
                String key = (String)entry.getKey();
                if (!path.startsWith(key + "_")) continue;
                baseName = (String)entry.getValue();
                String numPart = path.substring((key + "_").length());
                int variantNumber = 0;
                try {
                    variantNumber = Integer.parseInt(numPart);
                }
                catch (NumberFormatException left) {
                    // empty catch block
                }
                String displayName = variantNumber == 0 ? baseName + " Base" : baseName + " " + variantNumber;
                String baseKey = key.replace("_blockz", "");
                if (ModBlocks.VARIANTS_CTM.containsKey(baseKey)) {
                    for (int idx : ModBlocks.VARIANTS_CTM.get(baseKey)) {
                        if (idx != variantNumber) continue;
                        displayName = displayName + " (CTM)";
                        break;
                    }
                }
                if (ModBlocks.VARIANTS_PILLARS.containsKey(baseKey)) {
                    for (int idx : ModBlocks.VARIANTS_PILLARS.get(baseKey)) {
                        if (idx != variantNumber) continue;
                        displayName = displayName + " [Pillar]";
                        break;
                    }
                }
                langEntries.put("block.betterblockz." + path, displayName);
                continue block6;
            }
        }
        langEntries.forEach((arg_0, arg_1) -> ((BetterBlockZLangProvider)this).add(arg_0, arg_1));
    }

    private static String capitalizeWords(String s) {
        s = s.replace("_", " ");
        String[] parts = s.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            sb.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1).toLowerCase()).append(" ");
        }
        return sb.toString().trim();
    }
}

