/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.datagen;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;
import net.ricmc.betterblockz.item.ModItems;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final TagKey<Item> COPPER_INGOTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/copper"));
    private static final TagKey<Item> IRON_INGOTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/iron"));
    private static final TagKey<Item> GOLD_INGOTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/gold"));
    private static final TagKey<Item> DIAMOND_GEMS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gems/diamond"));

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()), (int)8).define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('S'), (ItemLike)Items.STONE).define(Character.valueOf('M'), (ItemLike)Items.SMOOTH_STONE).pattern("SCS").pattern("CMC").pattern("SCS").unlockedBy("has_cobble", ModRecipeProvider.has((ItemLike)Items.COBBLESTONE)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"betterblockz", (String)"blockz_core_cobble"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()), (int)8).define(Character.valueOf('S'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('C'), (ItemLike)Items.STONE).define(Character.valueOf('M'), (ItemLike)Items.SMOOTH_STONE).pattern("SCS").pattern("CMC").pattern("SCS").unlockedBy("has_cobble", ModRecipeProvider.has((ItemLike)Items.COBBLESTONE)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"betterblockz", (String)"blockz_core_stone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()), (int)8).define(Character.valueOf('S'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('C'), (ItemLike)Items.STONE).define(Character.valueOf('M'), (ItemLike)Items.SMOOTH_STONE).pattern("SSS").pattern("SMC").pattern("CCC").unlockedBy("has_cobble", ModRecipeProvider.has((ItemLike)Items.COBBLESTONE)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"betterblockz", (String)"blockz_core_mix1"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()), (int)8).define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('S'), (ItemLike)Items.STONE).define(Character.valueOf('M'), (ItemLike)Items.SMOOTH_STONE).pattern("SSS").pattern("SMC").pattern("CCC").unlockedBy("has_cobble", ModRecipeProvider.has((ItemLike)Items.COBBLESTONE)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"betterblockz", (String)"blockz_core_mix2"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.STONE_BLOCKZ.get()), (int)16).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).pattern("CCC").pattern("CSC").pattern("CCC").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VARIANT_SHUFFLER.get()), (int)5).define(Character.valueOf('C'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).pattern("C C").pattern(" C ").pattern("C C").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.AURORA_BLOCKZ.get()), (int)16).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('D'), (ItemLike)Items.GLASS).define(Character.valueOf('C'), Ingredient.of((TagKey)Tags.Items.DYES)).pattern("SCS").pattern("CDC").pattern("SCS").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.TRANSMUTER_BLOCKZ.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).pattern("SIS").pattern("WGL").pattern("SIS").unlockedBy("has_lava_bucket", ModRecipeProvider.has((ItemLike)Items.LAVA_BUCKET)).save(recipeOutput);
        this.buildItemRecipes(recipeOutput);
        this.registerCustom("iron", Ingredient.of(IRON_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("copper", Ingredient.of(COPPER_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("gold", Ingredient.of(GOLD_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("jelt", Ingredient.of(GOLD_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("diamond", Ingredient.of(DIAMOND_GEMS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("ironslate", Ingredient.of(IRON_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE, Items.COBBLED_DEEPSLATE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("forgecopper", Ingredient.of(COPPER_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("eclipse", Ingredient.of((ItemLike[])new ItemLike[]{Items.CHARCOAL, Items.COAL}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("armz", Ingredient.of((ItemLike[])new ItemLike[]{Items.GREEN_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("eclipse")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("eclipse")[0].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("stone", Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("ztyl", Ingredient.of(IRON_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHARCOAL, Items.COAL}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 16, recipeOutput);
        this.registerCustom("fort", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[8].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[8].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("zane", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[9].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[9].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("iszm", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[10].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[10].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("synthalloy", Ingredient.of(IRON_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 16, recipeOutput);
        this.registerCustom("ambercore", Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("synthalloy")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("synthalloy")[0].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("lablink", Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("synthalloy")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("synthalloy")[0].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("korp", Ingredient.of(IRON_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BLACKSTONE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("vect", Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("vena", Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("cray", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CLAY}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("reed", Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR_CANE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("myst", Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("crimson", Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_STEM, Items.CRIMSON_FUNGUS}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ironslate")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ironslate")[0].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("ironslateredstone", Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ironslate")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ironslate")[0].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("hazard", Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ironslate")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.YELLOW_DYE}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ironslate")[0].get()).asItem()}), 8, recipeOutput);
        this.registerCustom("lave", Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("agon", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("mint", Ingredient.of((ItemLike[])new ItemLike[]{Items.SLIME_BALL}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("azur", Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("bitt", Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("lairstain", Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERRACK}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("lairdecay", Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERRACK}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("lairhusk", Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_WART}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERRACK}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("lairflesh", Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERRACK}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("lairblood", Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_FUNGUS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERRACK}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("cyberlight", Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("cyberlight_alt", Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}), 8, recipeOutput);
        this.registerCustom("tintedglass", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS}), 8, recipeOutput);
        this.registerCustom("zoea", Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("ztyl")[0].get()).asItem()}), 8, recipeOutput);
        for (int i = 0; i < 4; ++i) {
            this.registerCustom("zoea_" + i, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("zoea")[i].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("zoea")[i].get()).asItem()}), 8, recipeOutput);
        }
        this.registerCustom("tank", Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 8, recipeOutput);
        this.registerCustom("number", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.AURORA_BLOCKZ.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 16, recipeOutput);
        Ingredient eclipse0 = Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("eclipse")[0].get()).asItem()});
        String[] zeonColors = new String[]{"white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink"};
        for (int i = 0; i < zeonColors.length; ++i) {
            String colorId = zeonColors[i];
            String baseName = "zeon_" + colorId;
            Ingredient cyberlightCenter = Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("cyberlight")[i].get()).asItem()});
            this.registerCustom(baseName, cyberlightCenter, eclipse0, eclipse0, 8, recipeOutput);
        }
        String[] zenoColors = new String[]{"white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink"};
        Map dyeMap = Map.ofEntries(Map.entry("white", Items.WHITE_DYE), Map.entry("light_gray", Items.LIGHT_GRAY_DYE), Map.entry("gray", Items.GRAY_DYE), Map.entry("black", Items.BLACK_DYE), Map.entry("brown", Items.BROWN_DYE), Map.entry("red", Items.RED_DYE), Map.entry("orange", Items.ORANGE_DYE), Map.entry("yellow", Items.YELLOW_DYE), Map.entry("lime", Items.LIME_DYE), Map.entry("green", Items.GREEN_DYE), Map.entry("cyan", Items.CYAN_DYE), Map.entry("light_blue", Items.LIGHT_BLUE_DYE), Map.entry("blue", Items.BLUE_DYE), Map.entry("purple", Items.PURPLE_DYE), Map.entry("magenta", Items.MAGENTA_DYE), Map.entry("pink", Items.PINK_DYE));
        for (String colorId : zenoColors) {
            String baseName = "zeno_" + colorId;
            Ingredient center = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)dyeMap.get(colorId)});
            Ingredient edge = Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GRAVEL});
            Ingredient corner = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()});
            this.registerCustom(baseName, center, edge, corner, 8, recipeOutput);
        }
        this.registerCustom("zenohex", Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("zeno_white")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{((Block)ModBlocks.VARIANTS.get("zeno_white")[0].get()).asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), 8, recipeOutput);
        this.registerCustom("metalzone_iron", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of(IRON_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 32, recipeOutput);
        this.registerCustom("metalzone_rustyiron", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of(IRON_INGOTS), 32, recipeOutput);
        this.registerCustom("metalzone_copper", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of(COPPER_INGOTS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), 32, recipeOutput);
        this.registerCustom("metalzone_rustycopper", Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.BLOCKZ_CORE.get()}), Ingredient.of(COPPER_INGOTS), 32, recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CYBERLIGHT_THIN.getFirst().get())).requires((ItemLike)ModBlocks.VARIANTS.get("cyberlight")[0].get()).unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput, "betterblockz:cyberlight_to_thin");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CYBERLIGHT_THIN_ALT.getFirst().get())).requires((ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get()).unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput, "betterblockz:cyberlight_alt_to_thin");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VARIANTS.get("cyberlight")[0].get())).requires((ItemLike)ModBlocks.CYBERLIGHT_THIN.getFirst().get()).unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput, "betterblockz:cyberlight_thin_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get())).requires((ItemLike)ModBlocks.CYBERLIGHT_THIN_ALT.getFirst().get()).unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput, "betterblockz:cyberlight_thin_alt_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get()), (int)2).requires((ItemLike)ModBlocks.CYBERLIGHT_BAR.getFirst().get()).unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput, "betterblockz:cyberlight_bar_to_cyberlight_alt");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get()), (int)2).requires((ItemLike)ModBlocks.CYBERLIGHT_BAR_VERTICAL.getFirst().get()).unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput, "betterblockz:cyberlight_bar_vertical_to_cyberlight_alt");
        this.addThinStonecutRecipes(recipeOutput, ModBlocks.CYBERLIGHT_THIN, "cyberlight");
        this.addThinStonecutRecipes(recipeOutput, ModBlocks.CYBERLIGHT_THIN_ALT, "cyberlight_alt");
        this.addThinStonecutRecipes(recipeOutput, ModBlocks.CYBERLIGHT_BAR, "cyberlight_bar");
        this.addThinStonecutRecipes(recipeOutput, ModBlocks.CYBERLIGHT_BAR_VERTICAL, "cyberlight_bar_vertical");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.FLAT_LAMP.get()), (int)8).define(Character.valueOf('M'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('L'), (ItemLike)Items.GLASS).pattern("GLG").pattern("LML").pattern("GLG").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
    }

    private void buildItemRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.COBBLE_CRAFTER.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('C'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SSS").pattern("WCL").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.AUTO_PLACER.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SSS").pattern("SIS").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.OMNI_SPADE.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('C'), (ItemLike)Items.DIAMOND).define(Character.valueOf('G'), (ItemLike)Items.GOLD_BLOCK).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SGS").pattern("SCS").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CHECKERED_SPADE.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('C'), (ItemLike)Items.DIAMOND).define(Character.valueOf('G'), (ItemLike)Items.GOLD_BLOCK).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SGS").pattern("GCG").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLOCK_REPLACER.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SSS").pattern("SES").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLOCK_EXTEND.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('E'), (ItemLike)Items.PISTON).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SSS").pattern("SES").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.META_WAND.get())).requires((ItemLike)ModItems.AUTO_PLACER.get()).requires((ItemLike)ModItems.BLOCK_REPLACER.get()).requires((ItemLike)ModItems.OMNI_SPADE.get()).requires((ItemLike)ModItems.BLOCK_EXTEND.get()).unlockedBy("has_auto_placer", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.AUTO_PLACER.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.COLOR_CHANGER.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('E'), (ItemLike)ModBlocks.AURORA_BLOCKZ.get()).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SSS").pattern("SES").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLOCK_DISCONNECT.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('E'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SSS").pattern("SES").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CYBERLIGHT_BAR.getFirst().get()), (int)1).define(Character.valueOf('A'), (ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get()).pattern("AA ").pattern("   ").pattern("   ").unlockedBy("has_cyberlight_alt", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get()))).save(recipeOutput, "betterblockz:cyberlight_bar_from_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CYBERLIGHT_BAR_VERTICAL.getFirst().get()), (int)1).define(Character.valueOf('A'), (ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get()).pattern("A  ").pattern("A  ").pattern("   ").unlockedBy("has_cyberlight_alt", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.VARIANTS.get("cyberlight_alt")[0].get()))).save(recipeOutput, "betterblockz:cyberlight_bar_vertical_from_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLOCK_RANDOMIZER.get())).define(Character.valueOf('S'), (ItemLike)ModBlocks.BLOCKZ_CORE.get()).define(Character.valueOf('C'), (ItemLike)Items.DIAMOND_BLOCK).define(Character.valueOf('G'), (ItemLike)Items.GOLD_BLOCK).define(Character.valueOf('P'), (ItemLike)Items.STICK).pattern("SGS").pattern("GCG").pattern(" P ").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(recipeOutput);
    }

    private void registerCustom(String baseName, Ingredient center, Ingredient edge, Ingredient corner, int count, RecipeOutput output) {
        DeferredBlock<?>[] variants = ModBlocks.VARIANTS.get(baseName);
        if (variants == null || variants.length == 0) {
            return;
        }
        Supplier<Block> baseBlock = () -> (Block)variants[0].get();
        Item unlockItem = center.getItems().length > 0 ? center.getItems()[0].getItem() : Items.COBBLESTONE;
        Set<String> noShapedRecipe = Set.of("cyberlight_secret");
        if (!noShapedRecipe.contains(baseName)) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)baseBlock.get()), (int)count).define(Character.valueOf('M'), center).define(Character.valueOf('S'), edge).define(Character.valueOf('C'), corner).pattern("CSC").pattern("SMS").pattern("CSC").unlockedBy("has_blockz_core", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.BLOCKZ_CORE.get()))).save(output, "betterblockz:" + baseName + "_custom");
        }
        int i = 1;
        while (i < variants.length) {
            int finalI = i++;
            Supplier<Block> variant = () -> (Block)variants[finalI].get();
            String variantName = BuiltInRegistries.BLOCK.getKey((Object)variant.get()).getPath();
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)baseBlock.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)variant.get())).unlockedBy("has_" + baseName, ModRecipeProvider.has((ItemLike)((ItemLike)baseBlock.get()))).save(output, "betterblockz:stonecut_" + baseName + "_to_" + variantName);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)variant.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)baseBlock.get())).unlockedBy("has_" + variantName, ModRecipeProvider.has((ItemLike)((ItemLike)variant.get()))).save(output, "betterblockz:stonecut_" + variantName + "_to_" + baseName);
        }
    }

    private void addThinStonecutRecipes(RecipeOutput recipeOutput, List<DeferredBlock<Block>> thinList, String prefix) {
        if (thinList.size() < 2) {
            return;
        }
        Block thin0 = (Block)thinList.get(0).get();
        for (int i = 1; i < thinList.size(); ++i) {
            Block other = (Block)thinList.get(i).get();
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{thin0}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)other).unlockedBy("has_" + String.valueOf(thin0), ModRecipeProvider.has((ItemLike)thin0)).save(recipeOutput, "betterblockz:" + prefix + "_thin0_to_variant" + i);
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{other}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)thin0).unlockedBy("has_" + String.valueOf(other), ModRecipeProvider.has((ItemLike)other)).save(recipeOutput, "betterblockz:" + prefix + "_variant" + i + "_to_thin0");
        }
    }

    public record CustomRecipe(Ingredient center, Ingredient edge, Ingredient corner, int count) {
    }
}

